package de.fiveminds.client.extensionAdapter;

import java.util.concurrent.CompletableFuture;

import de.fiveminds.client.dataModels.iam.Identity;
import de.fiveminds.client.dataModels.processDefinitions.ProcessDefinition;
import de.fiveminds.client.dataModels.processDefinitions.ProcessDefinition.ProcessModel;
import de.fiveminds.client.dataModels.processInstance.ProcessInstanceQuery;
import de.fiveminds.client.dataModels.processInstance.ProcessInstance.ProcessInstanceList;
import de.fiveminds.client.dataModels.processInstance.ProcessInstanceQuery.ProcessInstanceSortSettings;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

public interface IProcessInstanceExtensionAdapter {
	public CompletableFuture<ProcessInstanceList> query(@NonNull ProcessInstanceQuery query, ProcessInstanceQueryOptions options);
	
	public CompletableFuture<ProcessDefinition> getProcessDefinition(@NonNull String processInstanceId, Identity identity);
	
	public CompletableFuture<ProcessModel> getProcessModel(@NonNull String processInstanceId, Identity identity);
	
	public CompletableFuture<Void> transferOwnership(@NonNull String processInstanceId, @NonNull Identity newOwner, Identity identity);
	
	public CompletableFuture<Void> terminateProcessInstance(@NonNull String processInstanceId, Identity identity);
	
	public CompletableFuture<Void> retryProcessInstance(@NonNull String processInstanceId, ProcessInstanceRetryOptions options);
	
	public CompletableFuture<Void> deleteProcessInstances(@NonNull String[] processInstanceIds, boolean deleteAllRelatedData, Identity identity);
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class ProcessInstanceQueryOptions {
		private Identity identity;
		
		private Boolean includeXml;
		
		@Builder.Default private Integer offset = 0;
		
		@Builder.Default private Integer limit = 0;
		
		private ProcessInstanceSortSettings sortSettings;
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class ProcessInstanceRetryOptions {
		private String flowNodeInstanceId;
		
		private Object newStartToken;
		
		private Boolean updateProcessModel;
		
		private Identity identity;
	}
}
