package de.fiveminds.client.extensionAdapter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;

import de.fiveminds.client.dataModels.externalTasks.ExternalTask;
import de.fiveminds.client.dataModels.externalTasks.ExternalTaskError;
import de.fiveminds.client.dataModels.iam.Identity;
import lombok.NonNull;

public interface IExternalTaskExtensionAdapter {
	public CompletableFuture<String[]> getAllDeployedTopics(Identity identity);
	
	public <TPayload, TExternalTask extends ExternalTask<TPayload>> CompletableFuture<ExternalTask<TPayload>[]> fetchAndLockExternalTasks(
			@NonNull String workerId,
			@NonNull String[] topicNames,
			int maxTasks,
			int longPollingTimeout,
			int lockDuration,
			Pattern PayloadFilter,
			Identity identity,
			@NonNull Class<TExternalTask[]> externalTaskWithPayloadClass);
	
	public CompletableFuture<Void> extendLock(
			@NonNull String workerId,
			@NonNull String externalTaskId,
			int additionalDuration,
			Identity identity);
	
	public CompletableFuture<Void> handleError(
			@NonNull String workerId,
			@NonNull String externalTaskId,
			@NonNull ExternalTaskError error,
			Identity identity) throws UnsupportedEncodingException, URISyntaxException, IOException, InterruptedException;
	
	public <TResultType> CompletableFuture<Void> finishExternalTask(
			@NonNull String workerId,
			@NonNull String externalTaskId,
			@NonNull TResultType result,
			Identity identity) throws UnsupportedEncodingException, URISyntaxException, IOException, InterruptedException;
}
