package de.fiveminds.client.dataModels.processModel.viewModel;

import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class BaseElementViewModel {
	@NonNull private String id;
	
	@NonNull private Map<String, String> customProperties;
	
	private String documentation;
	
	@NonNull private String processModelId;
	
	private String processModelName;
	
	private String processModelVersion;

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class ProcessModelLike {
		@NonNull private String processModelId;
		
		private String processModelName;
		
		private String processModelVersion;
	}
}
