package de.fiveminds.client.dataModels.flowNodeInstance;

import java.util.HashMap;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.experimental.Accessors;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class UserTaskInstance extends FlowNodeInstance {
	private String actualOwnerId;
	
	private String finishedByUserId;
	
	private UserTaskConfig userTaskConfig;
	
	private UserTaskConfigModel userTaskConfigModel;
	
	private String[] assignedUserIds;

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class UserTaskConfig {
		private String[] assignedUserIds;
		
		@NonNull private UserTaskFormField[] formFields;
		
		private String customForm;
		
		private String description;
		
		private String finishedMessage;
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class UserTaskConfigModel {
		private String[] assignedUserIds;
		
		@NonNull private UserTaskFormField[] formFields;
		
		private String customForm;
		
		private String description;
		
		private String finishedMessage;
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class UserTaskFormField {
		@NonNull private String id;
		
		@NonNull private String type;
		
		@NonNull private String label;
		
		private Object defaultValue;
		
		private String customForm;
		
		private UserTaskEnumValue[] enumValues;
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class UserTaskEnumValue {
		@NonNull private String id;
		
		@NonNull private String name;
	}
	
	/**
	 * Describes the result set of a UserTask.
	 * Such a result set usually consists of a collection of FormFields and their assigned values.
	 */
	public static class UserTaskResult extends HashMap<String, Object>{

		private static final long serialVersionUID = -1934028778753754020L;
	};
	

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class UserTaskList {
		@NonNull private UserTaskInstance[] userTasks;
		
		public void setFlowNodeInstances(UserTaskInstance[] userTasks) {
			this.setUserTasks(userTasks);
		}
		
		private int totalCount;
	}
}
