package de.fiveminds.client.dataModels.flowNodeInstance;

import de.fiveminds.client.dataModels.flowNodeInstance.FlowNodeInstance.FlowNodeInstanceState;
import de.fiveminds.client.processModel.model.constants.BpmnType;
import de.fiveminds.client.processModel.model.constants.EventType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

public class Queries {
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	public static class FlowNodeInstanceBaseQuery {
		private String[] flowNodeId;
		
		private String[] flowNodeName;
		
		private String[] flowNodeLane;
		
		private String[] flowNodeInstanceId;
		
		private String[] previousFlowNodeInstanceId;
		
		private String[] processDefinitionId;
		
		private String[] processModelId;
		
		private String[] processInstanceId;
		
		private String[] correlationId;
		
		private String[] parentProcessInstanceId;
		
		private FlowNodeInstanceState[] state;
		
		private String[] ownerId;
		
		private String[] triggeredByFlowNodeInstance;
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class GenericFlowNodeInstanceQuery extends FlowNodeInstanceBaseQuery {
		private BpmnType[] flowNodeType;
		
		private EventType[] eventType;
	}

	@Data
	@AllArgsConstructor
	@Builder
	public static class UntypedTaskQuery extends FlowNodeInstanceBaseQuery {
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class EventQuery extends FlowNodeInstanceBaseQuery {
		private EventType[] eventType;
	}

	@Data
	@AllArgsConstructor
	@Builder
	public static class ManualTaskQuery extends FlowNodeInstanceBaseQuery {
	}

	@Data
	@AllArgsConstructor
	@Builder
	public static class UserTaskQuery extends FlowNodeInstanceBaseQuery {
	}
}
