package de.fiveminds.client.dataModels.externalTasks;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

public class ExternalTaskRequestPayloads {

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class ExtendLockRequestPayload {
		@NonNull private String workerId;
		
		@NonNull private Integer additionalDuration;
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class FetchAndLockRequestPayload {
		@NonNull private String workerId;
		
		@NonNull private String[] topicName;
		
		@NonNull private Integer maxTasks;
		
		@NonNull private Integer longPollingTimeout;
		
		@NonNull private Integer lockDuration;
		
		@NonNull private String payloadFilter;
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class FinishExternalTaskRequestPayload <TResult> {
		@NonNull private String workerId;
		
		@NonNull private TResult result;
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class HandleExternalTaskErrorRequestPayload {
		@NonNull private String workerId;
		
		@NonNull private ExternalTaskError error;
	}
}
