package de.fiveminds.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

import de.fiveminds.client.clients.ApplicationInfoHttpClient;
import de.fiveminds.client.clients.ProcessInstanceHttpClient;
import de.fiveminds.client.clients.ProcessModelHttpClient;
import de.fiveminds.client.clients.UserTaskHttpClient;
import de.fiveminds.client.dataModels.iam.Identity;
import de.fiveminds.client.lib.SocketIoManager;
import lombok.NonNull;

public class Client {
	public static final Identity dummyIdentity = Identity.builder()
			.userId("dummy_token")
			.token("ZHVtbXlfdG9rZW4=")
			.build();
	
	private final URI engineUrl;
	
	private final ApplicationInfoHttpClient applicationInfoHttpClient;
	private final ProcessInstanceHttpClient processInstanceHttpClient;
	private final ProcessModelHttpClient processModelHttpClient;
	private final UserTaskHttpClient userTaskHttpClient;
	
	public Client(@NonNull URI engineUrl, Identity identity) throws UnknownHostException, URISyntaxException {
		this.engineUrl = engineUrl;
		
		if (identity == null) {
			identity = dummyIdentity;
		}
		
		SocketIoManager socketIoManager = new SocketIoManager(engineUrl);
		
		this.applicationInfoHttpClient = new ApplicationInfoHttpClient(engineUrl, identity, socketIoManager);
		this.processInstanceHttpClient = new ProcessInstanceHttpClient(engineUrl, identity, socketIoManager);
		this.processModelHttpClient = new ProcessModelHttpClient(engineUrl, identity, socketIoManager);
		this.userTaskHttpClient = new UserTaskHttpClient(engineUrl, identity, socketIoManager);
	}
	
	public URI getEngineUrl() {
		return engineUrl;
	}
	
	public ApplicationInfoHttpClient applicationInfo() {
		return applicationInfoHttpClient;
	}
	
	public ProcessInstanceHttpClient processInstances() {
		return processInstanceHttpClient;
	}
	
	public ProcessModelHttpClient processModels() {
		return processModelHttpClient;
	}
	
	public UserTaskHttpClient userTasks() {
		return userTaskHttpClient;
	}
}
