/*
 * Decompiled with CFR 0.152.
 */
package utility;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dataModels.processInstance.BpmnError;
import errors.BaseError;
import errors.ErrorCodes;
import errors.ServerErrors;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import lombok.Generated;

public class DynamicBodyHandler<TResult>
implements HttpResponse.BodyHandler<TResult> {
    private static final int httpSuccessResponseCode = 200;
    private static final int httpRedirectResponseCode = 300;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Class<TResult> resultClass;

    @Override
    public HttpResponse.BodySubscriber<TResult> apply(HttpResponse.ResponseInfo responseInfo) {
        return HttpResponse.BodySubscribers.mapping(HttpResponse.BodySubscribers.ofString(Charset.defaultCharset()), jsonString -> {
            if (this.responseIsAnError(responseInfo)) {
                this.createAndThrowError(responseInfo.statusCode(), (String)jsonString);
            }
            if (this.resultClass == Void.class) {
                return null;
            }
            try {
                return objectMapper.readValue(jsonString, this.resultClass);
            }
            catch (JsonProcessingException error) {
                throw new RuntimeException("Failed to deserialize string to class " + this.resultClass.getName() + ".", error);
            }
        });
    }

    private boolean responseIsAnError(HttpResponse.ResponseInfo responseInfo) {
        return responseInfo.statusCode() < 200 || responseInfo.statusCode() >= 300;
    }

    private void createAndThrowError(int statusCode, String body) {
        BaseError deserializedError = BaseError.deserialize(body);
        if (BaseError.isEngineError(deserializedError)) {
            throw deserializedError;
        }
        if (deserializedError.additionalInformation != null) {
            BpmnErrorInfo bpmnErrorInfo;
            ObjectMapper objMapper = new ObjectMapper();
            try {
                bpmnErrorInfo = (BpmnErrorInfo)objMapper.readValue(deserializedError.additionalInformation, BpmnErrorInfo.class);
            }
            catch (JsonProcessingException error) {
                throw new RuntimeException("Could not deserialize additionalInformation.", error);
            }
            BpmnError newError = new BpmnError(bpmnErrorInfo.bpmnError.name, bpmnErrorInfo.bpmnError.code, bpmnErrorInfo.bpmnError.message, bpmnErrorInfo.bpmnError.stackTrace);
            newError.additionalInformation = bpmnErrorInfo.bpmnError.additionalInformation;
            throw newError;
        }
        ServerErrors.InternalServerError customError = new ServerErrors.InternalServerError(deserializedError.getMessage() == null ? "Failed to execute request" : deserializedError.getMessage(), null);
        customError.additionalInformation = deserializedError.additionalInformation;
        customError.code = ErrorCodes.fromValue(statusCode);
        customError.setStackTrace(deserializedError.getStackTrace());
        throw customError;
    }

    @Generated
    public DynamicBodyHandler(Class<TResult> resultClass) {
        this.resultClass = resultClass;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class BpmnErrorInfo {
        public BpmnErrorTemplate bpmnError;

        @Generated
        public BpmnErrorInfo() {
        }

        @Generated
        public BpmnErrorTemplate getBpmnError() {
            return this.bpmnError;
        }

        @Generated
        public void setBpmnError(BpmnErrorTemplate bpmnError) {
            this.bpmnError = bpmnError;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BpmnErrorInfo)) {
                return false;
            }
            BpmnErrorInfo other = (BpmnErrorInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BpmnErrorTemplate this$bpmnError = this.getBpmnError();
            BpmnErrorTemplate other$bpmnError = other.getBpmnError();
            return !(this$bpmnError == null ? other$bpmnError != null : !((Object)this$bpmnError).equals(other$bpmnError));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BpmnErrorInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BpmnErrorTemplate $bpmnError = this.getBpmnError();
            result = result * 59 + ($bpmnError == null ? 43 : ((Object)$bpmnError).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DynamicBodyHandler.BpmnErrorInfo(bpmnError=" + this.getBpmnError() + ")";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class BpmnErrorTemplate {
            public String name;
            public String code;
            public String message;
            public String stackTrace;
            public String additionalInformation;

            @Generated
            public BpmnErrorTemplate() {
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getCode() {
                return this.code;
            }

            @Generated
            public String getMessage() {
                return this.message;
            }

            @Generated
            public String getStackTrace() {
                return this.stackTrace;
            }

            @Generated
            public String getAdditionalInformation() {
                return this.additionalInformation;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setCode(String code) {
                this.code = code;
            }

            @Generated
            public void setMessage(String message) {
                this.message = message;
            }

            @Generated
            public void setStackTrace(String stackTrace) {
                this.stackTrace = stackTrace;
            }

            @Generated
            public void setAdditionalInformation(String additionalInformation) {
                this.additionalInformation = additionalInformation;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BpmnErrorTemplate)) {
                    return false;
                }
                BpmnErrorTemplate other = (BpmnErrorTemplate)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$code = this.getCode();
                String other$code = other.getCode();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                    return false;
                }
                String this$stackTrace = this.getStackTrace();
                String other$stackTrace = other.getStackTrace();
                if (this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace)) {
                    return false;
                }
                String this$additionalInformation = this.getAdditionalInformation();
                String other$additionalInformation = other.getAdditionalInformation();
                return !(this$additionalInformation == null ? other$additionalInformation != null : !this$additionalInformation.equals(other$additionalInformation));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BpmnErrorTemplate;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $code = this.getCode();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                String $stackTrace = this.getStackTrace();
                result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
                String $additionalInformation = this.getAdditionalInformation();
                result = result * 59 + ($additionalInformation == null ? 43 : $additionalInformation.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "DynamicBodyHandler.BpmnErrorInfo.BpmnErrorTemplate(name=" + this.getName() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", stackTrace=" + this.getStackTrace() + ", additionalInformation=" + this.getAdditionalInformation() + ")";
            }
        }
    }
}

