/*
 * Decompiled with CFR 0.152.
 */
package lib;

import dataModels.iam.Identity;
import engineEvents.Subscription;
import errors.UnauthorizedError;
import io.socket.client.IO;
import io.socket.client.Manager;
import io.socket.client.Socket;
import io.socket.client.SocketOptionBuilder;
import io.socket.emitter.Emitter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import utility.UriUtils;

public class SocketIoManager
implements AutoCloseable {
    private final URI engineUrl;
    private final Manager manager;
    private HashMap<String, Socket> socketCollection = new HashMap();
    private HashMap<String, Emitter.Listener> subscriptionCollection = new HashMap();

    public SocketIoManager(URI engineUrl) throws URISyntaxException {
        this.engineUrl = engineUrl.getScheme() == null ? UriUtils.replaceInUri(engineUrl, "http", null, null, null, null) : engineUrl;
        URI socketUri = UriUtils.replaceInUri(engineUrl, null, null, "/api", null, null);
        this.manager = new Manager(socketUri).open();
    }

    public void disconnectSocket(Identity identity) {
        Socket socketForIdentity = this.getSocketForIdentity(identity);
        if (socketForIdentity == null) {
            return;
        }
        socketForIdentity.disconnect().close();
        this.socketCollection.remove(identity.getUserId());
    }

    public Subscription createSocketIoSubscription(Identity identity, String eventName, Emitter.Listener callback, boolean subscribeOnce) throws UnauthorizedError, URISyntaxException {
        Socket socketForIdentity = this.createSocketForIdentity(identity);
        if (subscribeOnce) {
            socketForIdentity.once(eventName, callback);
        } else {
            socketForIdentity.on(eventName, callback);
        }
        String subscriptionId = UUID.randomUUID().toString();
        Subscription sub = new Subscription(subscriptionId, eventName, subscribeOnce);
        this.subscriptionCollection.put(subscriptionId, callback);
        return sub;
    }

    public void removeSocketIoSubscription(Identity identity, Subscription subscription) {
        Socket socketForIdentity = this.getSocketForIdentity(identity);
        if (socketForIdentity == null) {
            return;
        }
        Emitter.Listener callbackToRemove = this.subscriptionCollection.getOrDefault(subscription.getId(), null);
        if (callbackToRemove == null) {
            return;
        }
        socketForIdentity.off(subscription.getEventName(), callbackToRemove);
        this.socketCollection.remove(subscription.getId());
    }

    public Socket getSocketForIdentity(@NonNull Identity identity) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        return this.socketCollection.getOrDefault(identity.getUserId(), null);
    }

    private Socket createSocketForIdentity(@NonNull Identity identity) throws UnauthorizedError, URISyntaxException {
        boolean noAuthTokenProvided;
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        Socket existingSocket = this.getSocketForIdentity(identity);
        if (existingSocket != null) {
            return existingSocket;
        }
        boolean bl = noAuthTokenProvided = identity.getToken() == null || "".equals(identity.getToken());
        if (noAuthTokenProvided) {
            throw new UnauthorizedError(identity);
        }
        String urlPath = this.engineUrl.getPath();
        HashMap<String, List<String>> extraHeaders = new HashMap<String, List<String>>();
        extraHeaders.put("Authorization", List.of(identity.getToken()));
        extraHeaders.put("userId", List.of(identity.getUserId()));
        IO.Options options = SocketOptionBuilder.builder().setPath((String)(urlPath == null ? "/socket.io" : urlPath + "/socket.io")).build();
        HashMap<String, IO.Options> transportOptions = new HashMap<String, IO.Options>();
        transportOptions.put("polling", SocketOptionBuilder.builder().setExtraHeaders(extraHeaders).build());
        options.transportOptions = transportOptions;
        Socket sock = this.manager.socket("api", (Manager.Options)options).connect();
        this.socketCollection.put(identity.getUserId(), sock);
        return sock;
    }

    @Override
    public void close() {
        Iterator<Map.Entry<String, Socket>> iterator = this.socketCollection.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Socket> socketEntry = iterator.next();
            try {
                socketEntry.getValue().disconnect().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            iterator.remove();
        }
        this.manager.off();
    }
}

