/*
 * Decompiled with CFR 0.152.
 */
package clients;

import clients.BaseClient;
import clients.InternalHttpClient;
import dataModels.flowNodeInstance.FlowNodeInstance;
import dataModels.flowNodeInstance.Queries;
import dataModels.flowNodeInstance.UserTaskInstance;
import dataModels.iam.Identity;
import extensionAdapter.IUserTaskExtensionAdapter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lib.SocketIoManager;
import lombok.Generated;
import lombok.NonNull;
import processModel.model.constants.BpmnType;

public class UserTaskHttpClient
extends BaseClient
implements IUserTaskExtensionAdapter {
    protected UserTaskHttpClient(@NonNull URI engineUrl, @NonNull Identity identity, SocketIoManager socketIoManager) throws UnknownHostException, URISyntaxException {
        super(engineUrl, identity, socketIoManager);
        if (engineUrl == null) {
            throw new NullPointerException("engineUrl is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    @Override
    public CompletableFuture<UserTaskInstance.UserTaskList> query(@NonNull Queries.UserTaskQuery query, IUserTaskExtensionAdapter.UserTaskOptions options) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        FlowNodeInstance.FlowNodeInstanceSortSettings sortSettings = options == null ? null : options.getSortSettings();
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(this.identity);
        Queries.GenericFlowNodeInstanceQuery enhancedQuery = new Queries.GenericFlowNodeInstanceQuery();
        enhancedQuery.setFlowNodeType(new BpmnType[]{BpmnType.userTask});
        enhancedQuery.setFlowNodeId(query.getFlowNodeId());
        enhancedQuery.setFlowNodeName(query.getFlowNodeName());
        enhancedQuery.setFlowNodeLane(query.getFlowNodeLane());
        enhancedQuery.setFlowNodeInstanceId(query.getFlowNodeInstanceId());
        enhancedQuery.setPreviousFlowNodeInstanceId(query.getPreviousFlowNodeInstanceId());
        enhancedQuery.setProcessDefinitionId(query.getProcessDefinitionId());
        enhancedQuery.setProcessModelId(query.getProcessModelId());
        enhancedQuery.setProcessInstanceId(query.getProcessInstanceId());
        enhancedQuery.setCorrelationId(query.getCorrelationId());
        enhancedQuery.setParentProcessInstanceId(query.getParentProcessInstanceId());
        enhancedQuery.setState(query.getState());
        enhancedQuery.setOwnerId(query.getOwnerId());
        enhancedQuery.setTriggeredByFlowNodeInstance(query.getTriggeredByFlowNodeInstance());
        URI url = this.buildUrl("/flow_node_instances", options == null ? 0 : options.getOffset(), options == null ? 0 : options.getLimit(), enhancedQuery, sortSettings);
        CompletableFuture<HttpResponse<UserTaskInstance.UserTaskList>> httpResponse = this.httpClient.get(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), UserTaskInstance.UserTaskList.class);
        return httpResponse.thenApply(result -> (UserTaskInstance.UserTaskList)result.body());
    }

    @Override
    public CompletableFuture<Void> reserveUserTaskInstance(@NonNull Identity identity, @NonNull String flowNodeInstanceId, @NonNull String actualOwnerId) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (flowNodeInstanceId == null) {
            throw new NullPointerException("flowNodeInstanceId is marked non-null but is null");
        }
        if (actualOwnerId == null) {
            throw new NullPointerException("actualOwnerId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/user_tasks/:user_task_instance_id/reserve".replace(":user_task_instance_id", flowNodeInstanceId), 0, 0, null, null);
        class Body {
            public String actualOwnerId;

            @Generated
            public String getActualOwnerId() {
                return this.actualOwnerId;
            }

            @Generated
            public void setActualOwnerId(String actualOwnerId) {
                this.actualOwnerId = actualOwnerId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Body)) {
                    return false;
                }
                Body other = (Body)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$actualOwnerId = this.getActualOwnerId();
                String other$actualOwnerId = other.getActualOwnerId();
                return !(this$actualOwnerId == null ? other$actualOwnerId != null : !this$actualOwnerId.equals(other$actualOwnerId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Body;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $actualOwnerId = this.getActualOwnerId();
                result = result * 59 + ($actualOwnerId == null ? 43 : $actualOwnerId.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Body(actualOwnerId=" + this.getActualOwnerId() + ")";
            }

            @Generated
            public Body(String actualOwnerId) {
                this.actualOwnerId = actualOwnerId;
            }
        }
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.put(url, new Body(actualOwnerId), InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(result -> (Void)result.body());
    }

    @Override
    public CompletableFuture<Void> cancelUserTaskInstanceReservation(@NonNull Identity identity, @NonNull String flowNodeInstanceId) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (flowNodeInstanceId == null) {
            throw new NullPointerException("flowNodeInstanceId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/user_tasks/:user_task_instance_id/cancel-reservation".replace(":user_task_instance_id", flowNodeInstanceId), 0, 0, null, null);
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.delete(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(result -> (Void)result.body());
    }

    @Override
    public CompletableFuture<Void> finishUserTask(@NonNull String userTaskInstanceId, @NonNull UserTaskInstance.UserTaskResult userTaskResult, Identity identity) {
        if (userTaskInstanceId == null) {
            throw new NullPointerException("userTaskInstanceId is marked non-null but is null");
        }
        if (userTaskResult == null) {
            throw new NullPointerException("userTaskResult is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/user_tasks/:user_task_instance_id/finish".replace(":user_task_instance_id", userTaskInstanceId), 0, 0, null, null);
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.put(url, userTaskResult, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(result -> (Void)result.body());
    }
}

