/*
 * Decompiled with CFR 0.152.
 */
package clients;

import clients.BaseClient;
import clients.InternalHttpClient;
import dataModels.iam.Identity;
import dataModels.processDefinitions.ProcessDefinition;
import dataModels.processInstance.ProcessInstance;
import dataModels.processInstance.ProcessInstanceQuery;
import extensionAdapter.IProcessInstanceExtensionAdapter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lib.SocketIoManager;
import lombok.Generated;
import lombok.NonNull;

public class ProcessInstanceHttpClient
extends BaseClient
implements IProcessInstanceExtensionAdapter {
    protected ProcessInstanceHttpClient(@NonNull URI engineUrl, @NonNull Identity identity, SocketIoManager socketIoManager) throws UnknownHostException, URISyntaxException {
        super(engineUrl, identity, socketIoManager);
        if (engineUrl == null) {
            throw new NullPointerException("engineUrl is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    @Override
    public CompletableFuture<ProcessInstance.ProcessInstanceList> query(@NonNull ProcessInstanceQuery query, IProcessInstanceExtensionAdapter.ProcessInstanceQueryOptions options) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        ProcessInstanceQuery.ProcessInstanceSortSettings sortSettings = options == null ? null : options.getSortSettings();
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(this.identity);
        URI url = this.buildUrl("/process_instances/query", options == null ? 0 : options.getOffset(), options == null ? 0 : options.getLimit(), query, sortSettings);
        CompletableFuture<HttpResponse<ProcessInstance.ProcessInstanceList>> httpResponse = this.httpClient.get(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), ProcessInstance.ProcessInstanceList.class);
        return httpResponse.thenApply(result -> (ProcessInstance.ProcessInstanceList)result.body());
    }

    @Override
    public CompletableFuture<ProcessDefinition> getProcessDefinition(@NonNull String processInstanceId, Identity identity) {
        if (processInstanceId == null) {
            throw new NullPointerException("processInstanceId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/process_instances/:process_instance_id/process_definition".replace(":process_instance_id", processInstanceId), 0, 0, null, null);
        CompletableFuture<HttpResponse<ProcessDefinition>> httpResponse = this.httpClient.get(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), ProcessDefinition.class);
        return httpResponse.thenApply(result -> (ProcessDefinition)result.body());
    }

    @Override
    public CompletableFuture<ProcessDefinition.ProcessModel> getProcessModel(@NonNull String processInstanceId, Identity identity) {
        if (processInstanceId == null) {
            throw new NullPointerException("processInstanceId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/process_instances/:process_instance_id/process_model".replace(":process_instance_id", processInstanceId), 0, 0, null, null);
        CompletableFuture<HttpResponse<ProcessDefinition.ProcessModel>> httpResponse = this.httpClient.get(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), ProcessDefinition.ProcessModel.class);
        return httpResponse.thenApply(result -> (ProcessDefinition.ProcessModel)result.body());
    }

    @Override
    public CompletableFuture<Void> transferOwnership(@NonNull String processInstanceId, @NonNull Identity newOwner, Identity identity) {
        if (processInstanceId == null) {
            throw new NullPointerException("processInstanceId is marked non-null but is null");
        }
        if (newOwner == null) {
            throw new NullPointerException("newOwner is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/process_instances/:process_instance_id/change_owner".replace(":process_instance_id", processInstanceId), 0, 0, null, null);
        HashMap<String, Identity> body = new HashMap<String, Identity>();
        body.put("newOwner", newOwner);
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.put(url, body, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(httpResult -> (Void)httpResult.body());
    }

    @Override
    public CompletableFuture<Void> terminateProcessInstance(@NonNull String processInstanceId, Identity identity) {
        if (processInstanceId == null) {
            throw new NullPointerException("processInstanceId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/process_instances/:process_instance_id/terminate".replace(":process_instance_id", processInstanceId), 0, 0, null, null);
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.put(url, null, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(httpResult -> (Void)httpResult.body());
    }

    @Override
    public CompletableFuture<Void> retryProcessInstance(@NonNull String processInstanceId, final IProcessInstanceExtensionAdapter.ProcessInstanceRetryOptions options) {
        if (processInstanceId == null) {
            throw new NullPointerException("processInstanceId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(this.identity);
        URI url = this.buildUrl("/process_instances/:process_instance_id/retry".replace(":process_instance_id", processInstanceId), 0, 0, null, null);
        if (options != null && options.getFlowNodeInstanceId() != null) {
            url = this.addParameterToUrl(url, "flow_node_instance_id", options.getFlowNodeInstanceId());
        }
        if (options != null && options.getUpdateProcessModel() != null) {
            url = this.addParameterToUrl(url, "update_process_model", options.getUpdateProcessModel());
        }
        class Body {
            public Object newStartToken;

            @Generated
            public Body() {
                this.newStartToken = options == null ? null : options.getNewStartToken();
            }

            @Generated
            public Object getNewStartToken() {
                return this.newStartToken;
            }

            @Generated
            public void setNewStartToken(Object newStartToken) {
                this.newStartToken = newStartToken;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Body)) {
                    return false;
                }
                Body other = (Body)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Object this$newStartToken = this.getNewStartToken();
                Object other$newStartToken = other.getNewStartToken();
                return !(this$newStartToken == null ? other$newStartToken != null : !this$newStartToken.equals(other$newStartToken));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Body;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Object $newStartToken = this.getNewStartToken();
                result = result * 59 + ($newStartToken == null ? 43 : $newStartToken.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Body(newStartToken=" + this.getNewStartToken() + ")";
            }
        }
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.put(url, new Body(), InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(httpResult -> (Void)httpResult.body());
    }

    @Override
    public CompletableFuture<Void> deleteProcessInstances(@NonNull String[] processInstanceIds, boolean deleteAllRelatedData, Identity identity) {
        if (processInstanceIds == null) {
            throw new NullPointerException("processInstanceIds is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/process_instances", 0, 0, null, null);
        String serializedProcessInstanceIds = String.join((CharSequence)";", processInstanceIds);
        url = this.addParameterToUrl(url, "process_instance_ids", serializedProcessInstanceIds);
        if (deleteAllRelatedData) {
            url = this.addParameterToUrl(url, "delete_all_related_data", deleteAllRelatedData);
        }
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.delete(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(httpResult -> (Void)httpResult.body());
    }
}

