/*
 * Decompiled with CFR 0.152.
 */
package clients;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import utility.DynamicBodyHandler;
import utility.DynamicBodyPublisher;

public class InternalHttpClient {
    @NonNull
    private final URI url;

    public InternalHttpClient(@NonNull URI url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    public <TResponse> CompletableFuture<HttpResponse<TResponse>> get(@NonNull URI url, RequestOptions options, Class<TResponse> responseClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        ArrayList<String> headers = this.buildHeaders(options);
        HttpRequest request = HttpRequest.newBuilder(url).version(HttpClient.Version.HTTP_1_1).headers(headers.toArray(new String[headers.size()])).GET().timeout(Duration.ofMillis(options.getTimeout().intValue())).build();
        HttpClient httpClient = HttpClient.newBuilder().build();
        CompletableFuture<HttpResponse<TResponse>> response = httpClient.sendAsync(request, new DynamicBodyHandler<TResponse>(responseClass));
        return response;
    }

    public <TResponse> CompletableFuture<HttpResponse<TResponse>> delete(@NonNull URI url, RequestOptions options, Class<TResponse> responseClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        ArrayList<String> headers = this.buildHeaders(options);
        HttpRequest request = HttpRequest.newBuilder(url).version(HttpClient.Version.HTTP_1_1).headers(headers.toArray(new String[headers.size()])).DELETE().timeout(Duration.ofMillis(options.getTimeout().intValue())).build();
        HttpClient httpClient = HttpClient.newBuilder().build();
        CompletableFuture<HttpResponse<TResponse>> response = httpClient.sendAsync(request, new DynamicBodyHandler<TResponse>(responseClass));
        return response;
    }

    public <TResponse> CompletableFuture<HttpResponse<TResponse>> post(@NonNull URI url, Object payload, RequestOptions options, Class<TResponse> responseClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        ArrayList<String> headers = this.buildHeaders(options);
        headers.add("Content-Type");
        headers.add("application/json");
        HttpRequest request = HttpRequest.newBuilder(url).version(HttpClient.Version.HTTP_1_1).headers(headers.toArray(new String[headers.size()])).POST(new DynamicBodyPublisher(payload)).timeout(Duration.ofMillis(options.getTimeout().intValue())).build();
        HttpClient httpClient = HttpClient.newBuilder().build();
        CompletableFuture<HttpResponse<TResponse>> response = httpClient.sendAsync(request, new DynamicBodyHandler<TResponse>(responseClass));
        return response;
    }

    public <TResponse> CompletableFuture<HttpResponse<TResponse>> put(@NonNull URI url, Object payload, RequestOptions options, Class<TResponse> responseClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        ArrayList<String> headers = this.buildHeaders(options);
        headers.add("Content-Type");
        headers.add("application/json");
        HttpRequest request = HttpRequest.newBuilder(url).version(HttpClient.Version.HTTP_1_1).headers(headers.toArray(new String[headers.size()])).PUT(new DynamicBodyPublisher(payload)).timeout(Duration.ofMillis(options.getTimeout().intValue())).build();
        HttpClient httpClient = HttpClient.newBuilder().build();
        CompletableFuture<HttpResponse<TResponse>> response = httpClient.sendAsync(request, new DynamicBodyHandler<TResponse>(responseClass));
        return response;
    }

    private ArrayList<String> buildHeaders(RequestOptions options) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Access-Control-Allow-Origin");
        headers.add("*");
        headers.add("Content-Type");
        headers.add("application/json");
        headers.add("accept");
        headers.add("application/json");
        if (options == null || options.getHeaders() == null) {
            return headers;
        }
        headers.addAll(options.getHeaders());
        return headers;
    }

    public static class RequestOptions {
        public Integer timeout;
        public Collection<String> headers;

        @Generated
        private static Integer $default$timeout() {
            return 5000;
        }

        @Generated
        private static Collection<String> $default$headers() {
            return new ArrayList<String>();
        }

        @Generated
        public static RequestOptionsBuilder builder() {
            return new RequestOptionsBuilder();
        }

        @Generated
        public Integer getTimeout() {
            return this.timeout;
        }

        @Generated
        public Collection<String> getHeaders() {
            return this.headers;
        }

        @Generated
        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Generated
        public void setHeaders(Collection<String> headers) {
            this.headers = headers;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestOptions)) {
                return false;
            }
            RequestOptions other = (RequestOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$timeout = this.getTimeout();
            Integer other$timeout = other.getTimeout();
            if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
                return false;
            }
            Collection<String> this$headers = this.getHeaders();
            Collection<String> other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RequestOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            Collection<String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "InternalHttpClient.RequestOptions(timeout=" + this.getTimeout() + ", headers=" + this.getHeaders() + ")";
        }

        @Generated
        public RequestOptions(Integer timeout, Collection<String> headers) {
            this.timeout = timeout;
            this.headers = headers;
        }

        @Generated
        public RequestOptions() {
            this.timeout = RequestOptions.$default$timeout();
            this.headers = RequestOptions.$default$headers();
        }

        @Generated
        public static class RequestOptionsBuilder {
            @Generated
            private boolean timeout$set;
            @Generated
            private Integer timeout$value;
            @Generated
            private boolean headers$set;
            @Generated
            private Collection<String> headers$value;

            @Generated
            RequestOptionsBuilder() {
            }

            @Generated
            public RequestOptionsBuilder timeout(Integer timeout) {
                this.timeout$value = timeout;
                this.timeout$set = true;
                return this;
            }

            @Generated
            public RequestOptionsBuilder headers(Collection<String> headers) {
                this.headers$value = headers;
                this.headers$set = true;
                return this;
            }

            @Generated
            public RequestOptions build() {
                Integer timeout$value = this.timeout$value;
                if (!this.timeout$set) {
                    timeout$value = RequestOptions.$default$timeout();
                }
                Collection<String> headers$value = this.headers$value;
                if (!this.headers$set) {
                    headers$value = RequestOptions.$default$headers();
                }
                return new RequestOptions(timeout$value, headers$value);
            }

            @Generated
            public String toString() {
                return "InternalHttpClient.RequestOptions.RequestOptionsBuilder(timeout$value=" + this.timeout$value + ", headers$value=" + this.headers$value + ")";
            }
        }
    }
}

