/*
 * Decompiled with CFR 0.152.
 */
package clients;

import clients.ApplicationInfoHttpClient;
import clients.ProcessInstanceHttpClient;
import clients.ProcessModelHttpClient;
import clients.UserTaskHttpClient;
import dataModels.iam.Identity;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import lib.SocketIoManager;
import lombok.NonNull;

public class Client {
    public static final Identity dummyIdentity = Identity.builder().userId("dummy_token").token("ZHVtbXlfdG9rZW4=").build();
    private final URI engineUrl;
    private final ApplicationInfoHttpClient applicationInfoHttpClient;
    private final ProcessInstanceHttpClient processInstanceHttpClient;
    private final ProcessModelHttpClient processModelHttpClient;
    private final UserTaskHttpClient userTaskHttpClient;

    public Client(@NonNull URI engineUrl, Identity identity) throws UnknownHostException, URISyntaxException {
        if (engineUrl == null) {
            throw new NullPointerException("engineUrl is marked non-null but is null");
        }
        this.engineUrl = engineUrl;
        if (identity == null) {
            identity = dummyIdentity;
        }
        SocketIoManager socketIoManager = new SocketIoManager(engineUrl);
        this.applicationInfoHttpClient = new ApplicationInfoHttpClient(engineUrl, identity, socketIoManager);
        this.processInstanceHttpClient = new ProcessInstanceHttpClient(engineUrl, identity, socketIoManager);
        this.processModelHttpClient = new ProcessModelHttpClient(engineUrl, identity, socketIoManager);
        this.userTaskHttpClient = new UserTaskHttpClient(engineUrl, identity, socketIoManager);
    }

    public URI getEngineUrl() {
        return this.engineUrl;
    }

    public ApplicationInfoHttpClient applicationInfo() {
        return this.applicationInfoHttpClient;
    }

    public ProcessInstanceHttpClient processInstances() {
        return this.processInstanceHttpClient;
    }

    public ProcessModelHttpClient processModels() {
        return this.processModelHttpClient;
    }

    public UserTaskHttpClient userTasks() {
        return this.userTaskHttpClient;
    }
}

