/*
 * Decompiled with CFR 0.152.
 */
package clients;

import clients.BaseClient;
import clients.InternalHttpClient;
import dataModels.ApplicationInfo;
import dataModels.iam.Identity;
import extensionAdapter.IApplicationInfoExtensionAdapter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lib.SocketIoManager;
import lombok.NonNull;

public class ApplicationInfoHttpClient
extends BaseClient
implements IApplicationInfoExtensionAdapter {
    ApplicationInfoHttpClient(@NonNull URI engineUrl, @NonNull Identity identity, SocketIoManager socketIoManager) throws UnknownHostException, URISyntaxException {
        super(engineUrl, identity, socketIoManager);
        if (engineUrl == null) {
            throw new NullPointerException("engineUrl is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    @Override
    public CompletableFuture<ApplicationInfo> getApplicationInfo() {
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(this.identity);
        URI url = this.buildUrl("/info", 0, 0, null, null);
        CompletableFuture<HttpResponse<ApplicationInfo>> httpResponse = this.httpClient.get(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), ApplicationInfo.class);
        return httpResponse.thenApply(result -> (ApplicationInfo)result.body());
    }

    @Override
    public CompletableFuture<URI> getAuthorityAddress() {
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(this.identity);
        URI url = this.buildUrl("/authority", 0, 0, null, null);
        CompletableFuture<HttpResponse<URI>> httpResponse = this.httpClient.get(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), URI.class);
        return httpResponse.thenApply(result -> (URI)result.body());
    }
}

