package utility;

import java.net.URI;
import java.net.URISyntaxException;

import lombok.NonNull;

public class UriUtils {
	public static @NonNull URI replaceInUri(@NonNull URI url, String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
		return new URI(
				scheme == null ? url.getScheme() : scheme,
				authority == null ? url.getAuthority() : authority,
				path == null ? url.getPath() : path,
				query == null ? url.getQuery() : query,
				fragment == null ? url.getFragment() : fragment);
	}
	
	public static @NonNull URI extendPath(@NonNull URI url, String pathSegment) throws URISyntaxException {
		if (pathSegment == null) {
			return url;
		}
		
		String path = url.getPath();
		
		if (path != null && !path.endsWith("/") && !pathSegment.startsWith("/")) {
			path = path + '/';
		}
		
		path = path + pathSegment;
		return replaceInUri(url, null, null, path, null, null);
	}
}
