package types;

public class RestSettings {
	  public static final String baseRoute = "atlas_engine/api";

	  public static class Params {
		  /**
		   * Id of a Correlation.
		   */
		  public static final String correlationId = ":correlation_id";

		  /**
		   * Instance Id of an UntypedTask.
		   */
		  public static final String untypedTaskInstanceId = ":untyped_task_instance_id";

		  /**
		   * Deprecated version of "untypedTaskInstanceId"
		   */
		  public static final String emptyActivityInstanceId = ":empty_activity_instance_id";

		  /**
		   * Id of an Event.
		   */
		  public static final String eventId = ":event_id";

		  /**
		   * Name of an Event.
		   */
		  public static final String eventName = ":event_name";

		  /**
		   * Id of an External Task.
		   */
		  public static final String externalTaskId = ":external_task_id";

		  /**
		   * Id of a FlowNode.
		   */
		  public static final String flowNodeId = ":flow_node_id";

		  /**
		   * Id of a FlowNodeInstance.
		   */
		  public static final String flowNodeInstanceId = ":flow_node_instance_id";

		  /**
		   * Id of a ManualTask.
		   */
		  public static final String manualTaskInstanceId = ":manual_task_instance_id";

		  /**
		   * Instance Id of a Process.
		   */
		  public static final String processInstanceId = ":process_instance_id";

		  /**
		   * Id of a ProcessModel.
		   */
		  public static final String processDefinitionId = ":process_definition_id";

		  /**
		   * Id of a ProcessModel.
		   */
		  public static final String processModelId = ":process_model_id";

		  /**
		   * Id of an anonymous session.
		   */
		  public static final String sessionId = ":session_id";

		  /**
		   * Id of a user.
		   */
		  public static final String userId = ":user_id";

		  /**
		   * Id of a UserTaskInstance.
		   */
		  public static final String userTaskInstanceId = ":user_task_instance_id";

		  /**
		   * Key of a metadata value
		   */
		  public static final String userMetadataKey = ":user_metadata_key";
	  }

	  public static class Paths {
		  // ApplicationInfo

		  /**
		   * Gets some basic info about the host application.
		   */
		  public static final String getApplicationInfo = "/info";

		  /**
		   * Gets the address of the authority that the host application uses for claim checks.
		   */
		  public static final String getAuthorityAddress = "/authority";

		  // Anonymous Sessions

		  /**
		   * Returns the anonymous session with the given ID.
		   */
		  public static final String getAnonymousSessionById = "/anonymous_session/session/" + Params.sessionId;

		  /**
		   * Returns all anonymous sessions of the given User ID.
		   */
		  public static final String getAnonymousSessionsByUserId = "/anonymous_session/user/" + Params.userId;

		  /**
		   * Creates a new anonymous session and returns its ID.
		   */
		  public static final String createAnonymousSession = "/anonymous_session";

		  // Correlations

		  /**
		   * Gets all Correlations.
		   */
		  public static final String getCorrelations = "/correlations";

		  /**
		   * Gets a Correlation by its ID.
		   */
		  public static final String getCorrelationById = "/correlations/" + Params.correlationId;

		  // Cronjobs

		  /**
		   * Queries a list of deployed Cronjobs.
		   */
		  public static final String getDeployedCronjobs = "/cronjobs/query";

		  /**
		   * Enables the given Cronjob for the given Process Model.
		   */
		  public static final String enableCronjob = "/cronjobs/process_models/" + Params.processModelId + "/flow_node/" + Params.flowNodeId + "/enable";

		  /**
		   * Disables the given Cronjob for the given ProcessModel.
		   */
		  public static final String disableCronjob = "/cronjobs/process_models/" + Params.processModelId + "/flow_node/" + Params.flowNodeId + "/disable";

		  // DataObjects

		  /**
		   * Gets the DataObjectInstances that match the given query.
		   */
		  public static final String getDataObjects = "/data_object_instances/query";

		  // FlowNodeInstance

		  /**
		   * Gets all FlowNodeInstances that match the given query.
		   */
		  public static final String queryFlowNodeInstances = "/flow_node_instances";

		  /**
		   * Triggers a MessageEvent by its name.
		   */
		  public static final String triggerMessageEvent = "/messages/" + Params.eventName + "/trigger";

		  /**
		   * Triggers a SignalEvent by its name.
		   */
		  public static final String triggerSignalEvent = "/signals/" + Params.eventName + "/trigger";

		  /**
		   * Finishes a specific UntypedTask by its InstanceId.
		   */
		  public static final String finishUntypedTask = "/untyped_tasks/" + Params.untypedTaskInstanceId + "/finish";

		  /**
		   * Finishes a specific ManualTask by its ManualTaskInstanceId.
		   */
		  public static final String finishManualTask = "/manual_tasks/" + Params.manualTaskInstanceId + "/finish";

		  /**
		   * Finishes a specific UserTask by its UserTaskInstanceId.
		   */
		  public static final String finishUserTask = "/user_tasks/" + Params.userTaskInstanceId + "/finish";

		  /**
		   * Reserves a UserTask for a specific User.
		   */
		  public static final String reserveUserTaskInstance = "/user_tasks/" + Params.userTaskInstanceId + "/reserve";

		  /**
		   * Cancels the reservation of the given UserTask instance.
		   */
		  public static final String cancelUserTaskInstanceReservation = "/user_tasks/" + Params.userTaskInstanceId + "/cancel-reservation";

		  // External Tasks

		  /**
		   * Fetches a list of all ExternalTask topics from all deployed Process Models.
		   */
		  public static final String getAllDeployedTopics = "/external_tasks/deployed_topics";

		  /**
		   * Fetches the tasks available for an ExternalTaskWorker and locks them for a defined time.
		   */
		  public static final String fetchAndLockExternalTasks = "/external_tasks/fetch_and_lock";

		  /**
		   * Extends the lock duration of an ExternalTask by a given amount of time.
		   */
		  public static final String extendExternalTaskLock = "/external_tasks/" + Params.externalTaskId + "/extend_lock";

		  /**
		   * Finishes the given External Task with the given Error.
		   */
		  public static final String finishExternalTaskWithError = "/external_tasks/" + Params.externalTaskId + "/error";

		  /**
		   * Finishes the ExternalTask with the given ID.
		   */
		  public static final String finishExternalTask = "/external_tasks/" + Params.externalTaskId + "/finish";

		  // ProcessDefinition

		  /**
		   * Creates or updates a ProcessDefinition or a list of ProcessDefinitions.
		   */
		  public static final String persistProcessDefinitions = "/process_definitions";

		  /**
		   * Gets all ProcessDefinitions the requesting user is allowed to see.
		   */
		  public static final String getProcessDefinitions = "/process_definitions";

		  /**
		   * Gets a ProcessDefinition by its id.
		   */
		  public static final String getProcessDefinitionById = "/process_definitions/" + Params.processDefinitionId;

		  /**
		   * Deletes the ProcessDefinition with the given ID.
		   * Per default, a Process is only flagged as deleted. To actually delete the Process and all related data, set "delete_all_related_data" to "true".
		   */
		  public static final String deleteProcessDefinition = "/process_definitions/" + Params.processDefinitionId;

		  // ProcessModels

		  /**
		   * Gets all currently deployed Process Models.
		   */
		  public static final String getAllProcessModels = "/process_models";

		  /**
		   * Gets a deployed Process Model by its ID.
		   */
		  public static final String getProcessModelById = "/process_models/" + Params.processModelId + "/";

		  /**
		   * Gets a ProcessDefinition for a given ProcessModel.
		   */
		  public static final String getProcessDefinitionForProcessModel = "/process_models/" + Params.processModelId + "/process_definition";

		  /**
		   * Starts a new instance from the given set of parameters.
		   */
		  public static final String startProcessInstance = "/process_models/" + Params.processModelId + "/start";

		  /**
		   * Deletes the ProcessDefinition that contains the Process Model with the given ID.
		   * Per default, a Process is only flagged as deleted. To actually delete the Process and all related data, set "delete_all_related_data" to "true".
		   */
		  public static final String deleteProcessDefinitionByProcessModelId = "/process_models/" + Params.processModelId;

		  /**
		   * Enables the given Process Model.
		   */
		  public static final String enableProcessModel = "/process_models/" + Params.processModelId + "/enable";

		  /**
		   * Disables the given Process Model.
		   */
		  public static final String disableProcessModel = "/process_models/" + Params.processModelId + "/disable";

		  // ProcessInstance

		  /**
		   * Gets all ProcessInstances that match the given query.
		   */
		  public static final String queryProcessInstances = "/process_instances/query";

		  /**
		   * Gets the ProcessDefinition for a given ProcessInstance.
		   */
		  public static final String getProcessDefinitionForProcessInstance = "/process_instances/" + Params.processInstanceId + "/process_definition";

		  /**
		   * Gets the ProcessModel for a given ProcessInstance.
		   */
		  public static final String getProcessModelForProcessInstance = "/process_instances/" + Params.processInstanceId + "/process_model";

		  /**
		   * Changes the owner of the ProcessInstance with the given ID.
		   */
		  public static final String changeProcessInstanceOwner = "/process_instances/" + Params.processInstanceId + "/change_owner";

		  /**
		   * Terminates the ProcessInstance with the given ID.
		   */
		  public static final String terminateProcessInstances = "/process_instances/" + Params.processInstanceId + "/terminate";

		  /**
		   * Retries a failed or terminated Process Instance from the original point of failure.
		   * Alternatively, the Process Instance can be reset to a specific flow Node Instance, provided with the "flow_node_instance_id" Query parameter
		   */
		  public static final String retryProcessInstance = "/process_instances/" + Params.processInstanceId + "/retry";

		  /**
		   * Deletes the given Set of Process Instances. Multiple ProcessInstanceIds can be provided with ";" as separator.
		   * Per default, a Process Instance is only flagged as deleted. To actually delete the Process Instances and all related data, set "delete_all_related_data" to "true".
		   */
		  public static final String deleteProcessInstances = "/process_instances";

		  // UserMetadataStorage

		  /**
		   * Queries all values by the given keys
		   */
		  public static final String queryUserMetadata = "/user_metadata/query";

		  /**
		   * Gets a value by the given key
		   */
		  public static final String getUserMetadata = "/user_metadata/" + Params.userMetadataKey;

		  /**
		   * Sets a value for the given key
		   */
		  public static final String setUserMetadata = "/user_metadata/" + Params.userMetadataKey;

		  /**
		   * Removes a value for the given key
		   */
		  public static final String removeUserMetadata = "/user_metadata/" + Params.userMetadataKey;

		  // Long Polling Notifications

		  /**
		   * Wait for a CronjobCreated notification and resolves with the notification's content.
		   */
		  public static final String onCronjobCreated = "/notifications/long_polling/cronjob_created";

		  /**
		   * Wait for a CronjobExecuted notification and resolves with the notification's content.
		   */
		  public static final String onCronjobExecuted = "/notifications/long_polling/cronjob_executed";

		  /**
		   * Wait for a CronjobStopped notification and resolves with the notification's content.
		   */
		  public static final String onCronjobStopped = "/notifications/long_polling/cronjob_stopped";

		  /**
		   * Wait for a CronjobUpdated notification and resolves with the notification's content.
		   */
		  public static final String onCronjobUpdated = "/notifications/long_polling/cronjob_updated";

		  /**
		   * Wait for a CronjobRemoved notification and resolves with the notification's content.
		   */
		  public static final String onCronjobRemoved = "/notifications/long_polling/cronjob_removed";

		  /**
		   * Wait for a ProcessDeployed notification and resolves with the notification's content.
		   */
		  public static final String onProcessDeployed = "/notifications/long_polling/process_deployed";

		  /**
		   * Wait for a ProcessIsExecutableChanged notification and resolves with the notification's content.
		   */
		  public static final String onProcessIsExecutableChanged = "/notifications/long_polling/process_is_executable_changed";

		  /**
		   * Wait for a CronjobEnabledChanged notification and resolves with the notification's content.
		   */
		  public static final String onCronjobEnabledChanged = "/notifications/long_polling/cronjob_enabled_changed";

		  /**
		   * Wait for a ProcessUndeployed notification and resolves with the notification's content.
		   */
		  public static final String onProcessUndeployed = "/notifications/long_polling/process_undeployed";

		  /**
		   * Wait for a ProcessStarting notification and resolves with the notification's content.
		   */
		  public static final String onProcessStarting = "/notifications/long_polling/process_starting";

		  /**
		   * Wait for a ProcessStarted notification and resolves with the notification's content.
		   */
		  public static final String onProcessStarted = "/notifications/long_polling/process_started";

		  /**
		   * Wait for a ProcessResumed notification and resolves with the notification's content.
		   */
		  public static final String onProcessResumed = "/notifications/long_polling/process_resumed";

		  /**
		   * Wait for a ProcessEnded notification and resolves with the notification's content.
		   */
		  public static final String onProcessEnded = "/notifications/long_polling/process_ended";

		  /**
		   * Wait for a ProcessOwnerChanged notification and resolves with the notification's content.
		   */
		  public static final String onProcessOwnerChanged = "/notifications/long_polling/process_owner_changed";

		  /**
		   * Wait for a ProcessTerminated notification and resolves with the notification's content.
		   */
		  public static final String onProcessTerminated = "/notifications/long_polling/process_terminated";

		  /**
		   * Wait for a ProcessError notification and resolves with the notification's content.
		   */
		  public static final String onProcessError = "/notifications/long_polling/process_error";

		  /**
		   * Wait for a ProcessInstancesDeleted notification and resolves with the notification's content.
		   */
		  public static final String onProcessInstancesDeleted = "/notifications/long_polling/process_instances_deleted";

		  /**
		   * Wait for an ExternalTaskCreated notification and resolves with the notification's content.
		   */
		  public static final String onExternalTaskCreated = "/notifications/long_polling/external_task_created";

		  /**
		   * Wait for a ExternalTaskLocked notification and resolves with the notification's content.
		   */
		  public static final String onExternalTaskLocked = "/notifications/long_polling/external_task_locked";

		  /**
		   * Wait for a ExternalTaskUnlocked notification and resolves with the notification's content.
		   */
		  public static final String onExternalTaskUnlocked = "/notifications/long_polling/external_task_unlocked";

		  /**
		   * Wait for a ExternalTaskExpired notification and resolves with the notification's content.
		   */
		  public static final String onExternalTaskExpired = "/notifications/long_polling/external_task_expired";

		  /**
		   * Wait for an ActivityReached notification and resolves with the notification's content.
		   */
		  public static final String onActivityReached = "/notifications/long_polling/activity_reached";

		  /**
		   * Wait for an ActivityFinished notification and resolves with the notification's content.
		   */
		  public static final String onActivityFinished = "/notifications/long_polling/activity_finished";

		  /**
		   * Wait for an ActivityCanceled notification and resolves with the notification's content.
		   */
		  public static final String onActivityCanceled = "/notifications/long_polling/activity_canceled";

		  /**
		   * Wait for an UntypedTaskWaiting notification and resolves with the notification's content.
		   */
		  public static final String onUntypedTaskWaiting = "/notifications/long_polling/empty_activity_waiting";

		  /**
		   * Wait for an UntypedTaskFinished notification and resolves with the notification's content.
		   */
		  public static final String onUntypedTaskFinished = "/notifications/long_polling/empty_activity_finished";

		  /**
		   * Wait for a ManualTaskWaiting notification and resolves with the notification's content.
		   */
		  public static final String onManualTaskWaiting = "/notifications/long_polling/manual_task_waiting";

		  /**
		   * Wait for a ManualTaskFinied notification and resolves with the notification's content.
		   */
		  public static final String onManualTaskFinished = "/notifications/long_polling/manual_task_finished";

		  /**
		   * Wait for a UserTaskWaiting notification and resolves with the notification's content.
		   */
		  public static final String onUserTaskWaiting = "/notifications/long_polling/user_task_waiting";

		  /**
		   * Wait for a UserTaskFinished notification and resolves with the notification's content.
		   */
		  public static final String onUserTaskFinished = "/notifications/long_polling/user_task_finished";

		  /**
		   * Wait for a UserTaskReserved notification and resolves with the notification's content.
		   */
		  public static final String onUserTaskReserved = "/notifications/long_polling/user_task_reserved";

		  /**
		   * Wait for a UserTaskReservationCanceled notification and resolves with the notification's content.
		   */
		  public static final String onUserTaskReservationCanceled = "/notifications/long_polling/user_task_reservation_canceled";

		  /**
		   * Wait for a BoundaryEventTriggered notification and resolves with the notification's content.
		   */
		  public static final String onBoundaryEventTriggered = "/notifications/long_polling/boundary_event_triggered";

		  /**
		   * Wait for a BoundaryEventFinished notification and resolves with the notification's content.
		   */
		  public static final String onBoundaryEventFinished = "/notifications/long_polling/boundary_event_finished";

		  /**
		   * Wait for an IntermediateThrowEventTriggered notification and resolves with the notification's content.
		   */
		  public static final String onIntermediateThrowEventTriggered = "/notifications/long_polling/intermediate_throw_event_triggered";

		  /**
		   * Wait for an IntermediateCatchEventReached notification and resolves with the notification's content.
		   */
		  public static final String onIntermediateCatchEventReached = "/notifications/long_polling/intermediate_catch_event_reached";

		  /**
		   *
		   * Wait for a IntermediateCatchEventFinished notification and resolves with the notification's content.
		   */
		  public static final String onIntermediateCatchEventFinished = "/notifications/long_polling/intermediate_catch_event_finished";

		  /**
		   *
		   * Wait for a FlowNodeEventRetrySending notification and resolves with the notification's content.
		   */
		  public static final String onFlowNodeEventRetrySending = "/notifications/long_polling/flow_node_event_retry_sending";

		  /**
		   * Wait for an MessageTriggered notification and resolves with the notification's content.
		   */
		  public static final String onMessageTriggered = "/notifications/long_polling/message_triggered";

		  /**
		   * Wait for an SignalTriggered notification and resolves with the notification's content.
		   */
		  public static final String onSignalTriggered = "/notifications/long_polling/signal_triggered";

		  /**
		   * Wait for an EndEventFinished notification and resolves with the notification's content.
		   */
		  public static final String onEndEventFinished = "/notifications/long_polling/end_event_finished";

		  /**
		   * Wait for an StartEventFinished notification and resolves with the notification's content.
		   */
		  public static final String onStartEventFinished = "/notifications/long_polling/start_event_finished";

		  /**
		   * Wait for a ProcessInstanceMetadataChanged notification and resolves with the notification's content.
		   */
		  public static final String onProcessInstanceMetadataChanged = "/notifications/long_polling/process_instance_metadata_changed";

		  /**
		   * Wait for a CorrelationMetadataChanged notification and resolves with the notification's content.
		   */
		  public static final String onCorrelationMetadataChanged = "/notifications/long_polling/correlation_metadata_changed";
	  }
}
