package errors;

import lombok.NonNull;

@SuppressWarnings("serial")
public class ServerErrors {
	public static class BadGatewayError extends BaseError {
		public BadGatewayError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.BadGatewayError, message, category);
		}
	}

	public static class BandwithLimitExceededError extends BaseError {
		public BandwithLimitExceededError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.BandwithLimitExceededError, message, category);
		}
	}

	public static class GatewayTimeoutError extends BaseError {
		public GatewayTimeoutError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.GatewayTimeoutError, message, category);
		}
	}

	public static class InsufficientStorageError extends BaseError {
		public InsufficientStorageError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.InsufficientStorageError, message, category);
		}
	}

	public static class InternalServerError extends BaseError {
		public InternalServerError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.InternalServerError, message, category);
		}
	}

	public static class LoopDetectedError extends BaseError {
		public LoopDetectedError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.LoopDetectedError, message, category);
		}
	}

	public static class NetworkAuthenticationRequiredError extends BaseError {
		public NetworkAuthenticationRequiredError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.NetworkAuthenticationRequiredError, message, category);
		}
	}

	public static class NotImplementedError extends BaseError {
		public NotImplementedError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.NotImplementedError, message, category);
		}
	}

	public static class ServiceUnavaliableError extends BaseError {
		public ServiceUnavaliableError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.ServiceUnavaliableError, message, category);
		}
	}

	public static class VersionNotSupportedError extends BaseError {
		public VersionNotSupportedError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.VersionNotSupportedError, message, category);
		}
	}
}
