package errors;

import lombok.NonNull;

@SuppressWarnings("serial")
public class RedirectErrors {
	public static class FoundError extends BaseError {
		public FoundError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.FoundError, message, category);
		}
	}

	public static class MovedError extends BaseError {
		public MovedError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.MovedError, message, category);
		}
	}

	public static class MultipleChoicesError extends BaseError {
		public MultipleChoicesError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.MultipleChoicesError, message, category);
		}
	}

	public static class NotModifiedError extends BaseError {
		public NotModifiedError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.NotModifiedError, message, category);
		}
	}

	public static class PermanentRedirectError extends BaseError {
		public PermanentRedirectError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.PermanentRedirectError, message, category);
		}
	}

	public static class SeeOtherError extends BaseError {
		public SeeOtherError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.SeeOtherError, message, category);
		}
	}

	public static class TemporaryRedirectError extends BaseError {
		public TemporaryRedirectError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.TemporaryRedirectError, message, category);
		}
	}

	public static class UseProxyError extends BaseError {
		public UseProxyError(@NonNull String message, ErrorCategory category) {
			super(ErrorCodes.UseProxyError, message, category);
		}
	}
}
