package engineEvents;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
/**
 * Contains information about a subscription on the EventAggregator.
 * External services can use this information to manage their own subscriptions.
 */
public class Subscription {
	/**
	 * The Id under which the EventAggregator has stored the Subscription.
	 */
	private String id;
	
	/**
	 * The name of the event for which the Subscription was created.
	 */
	private String eventName;
	
	/**
	 * If set to true, the Subscription will be destroyed after first receiving
	 * the event.
	 */
	private boolean onlyReceiveOnce;
}
