package dataModels.processModel.model.base;

import java.util.Map.Entry;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ExtensionElements {
	private CamundaExecutionListener camundaExecutionListener;
	
	private CamundaExtensionProperty[] camundaExtensionProperties;
	
	private Entry<String, Object> signavioLabel;
	
	private SignavioMetadata[] signavioMetaData;
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class CamundaExecutionListener {
		// @NonNull Object class; TODO: Cannot name this field class
		
		@NonNull Object event;
	}
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class CamundaExtensionProperty {
		@NonNull private String name;
		
		@NonNull private String value;
	}
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class SignavioMetadata {
		@NonNull String metaKey;
		
		@NonNull String metaValue;
	}
}
