package dataModels.processInstance;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
/**
 * Contains a response from the Engine, which will be send after a ProcessInstance was started.
 * Depending on the type of start callback used, this will also contain information about the reached EndEvent.
 */
public class ProcessStartResponse {
	/**
	 * The ID of the ProcessInstance.
	 */
	@NonNull private String processInstanceId;
	
	/**
	 * The ID of the Correlation in which the started ProcessInstance runs.
	 */
	@NonNull private String correlationId;
	
	/**
	 * If the Engine is set to wait for the ProcessInstance to finish,
	 * this will contain the ID of the EndEvent with which ProcessInstance was finished.
	 */
	private String endEventId;
	
	/**
	 * If the Engine is set to wait for the ProcessInstance to finish,
	 * this will contain the final result with which ProcessInstance was finished.
	 */
	private Object tokenPayload;
}
