package dataModels.processInstance;

import java.util.Date;

import dataModels.processInstance.ProcessInstance.ProcessInstanceState;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import processModel.model.constants.EventType;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ProcessInstanceQuery {
	private SearchQuery<?> correlationId;
	
	private SearchQuery<?> processInstanceId;
	
	private SearchQuery<?> processDefinitionId;
	
	private SearchQuery<?> processModelId;
	
	private SearchQuery<?> processModelName;
	
	private SearchQuery<?> processModelHash;
	
	private SearchQuery<?> processModelVersion;
	
	private SearchQuery<?> ownerId;
	
	private Boolean startedByRootAccessToken;
	
	private SearchQuery<?> anonymousSessionId;
	
	private ProcessInstanceState[] state;
	
	private SearchQuery<?> parentProcessInstanceId;
	
	private Date[] finishedAt;
	
	private Date finishedBefore;
	
	private Date finishedAfter;
	
	private SearchQuery<?> terminatedByUserId;
	
	private Date[] createdAt;
	
	private Date createdBefore;
	
	private Date createdAfter;
	
	private Date[] updatedAt;
	
	private Date updatedBefore;
	
	private Date updatedAfter;
	
	private Integer durationInMillisecondsGreaterThan;
	
	private Integer durationInMillisecondsLessThan;
	
	private SearchQuery<?> startToken;
	
	private SearchQuery<?>  startEventId;
	
	private EventType[] startEventType;
	
	private SearchQuery<?> endToken;
	
	private SearchQuery<?> endEventId;
	
	private EventType[] endEventType;
	
	private SearchQuery<?> correlationMetadata;
	
	private SearchQuery<?> processInstanceMetadata;
	
	private SearchQuery<?> triggeredByFlowNodeInstance;

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class SearchQuery<TParamType> {
		@NonNull private SearchQueryOperator operator;
		@NonNull private TParamType[] searchParams;
	}

	public static class SearchQueryWithSearchParams extends SearchQuery<SearchParams> {
	}
	
	public static class SearchQueryWithString extends SearchQuery<String> {
	}
	
	public static class SearchQueryWithSearchQuery extends SearchQuery<SearchQuery<?>> {
	}
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class SearchParams {
		@NonNull private String searchString;
		
		private Boolean caseSensitive;
		
		private Boolean partialMatch;
	}
	
	public static enum SearchQueryOperator {
		or,
		and
	}
	
	public static enum ProcessInstanceSortableColumns {
		correlationId,
		processInstanceId,
		processDefinitionId,
		processModelId,
		processModelName,
		processModelVersion,
		processModelHash,
		ownerId,
		startedByRootAccessToken,
		state,
		error,
		parentProcessInstanceId,
		finishedAt,
		terminatedByUserId,
		createdAt,
		updatedAt,
		durationInMilliseconds,
		startToken,
		startEventId,
		startEventType,
		endToken,
		endEventId,
		endEventType,
		correlationMetadata,
		processInstanceMetadata,
		triggeredByFlowNodeInstance,
	}
	
	public static enum ProcessInstanceSortDirection {
		ASC,
		DESC,
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class ProcessInstanceSortSettings {
		@NonNull private ProcessInstanceSortableColumns sortBy;
		
		private ProcessInstanceSortDirection sortDir;
	}
}
