package dataModels.iam;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
/**
 * Contains information about an identity.
 */
public class Identity {
	/**
	 * The ID of the user to which this identity belongs.
	 */
	@NonNull private String token;
	
	/**
	 * The ID of the auth token's owner.
	 */
	@NonNull private String userId;
	
	/**
	 * The ID of an anonymous session.
	 * Should be set, when the auth token belongs to an anonymous user.
	 */
	private String anonymousSessionId;
}
