package dataModels.flowNodeInstance;

import java.util.Date;
import java.util.HashMap;

import javax.swing.event.DocumentEvent.EventType;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import processModel.model.constants.BpmnType;
import processModel.model.events.errorEvents.Error;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class FlowNodeInstance {	
	/**
	 * The instance ID of this FlowNodeInstance.
	 */
	private String flowNodeInstanceId;
	
	/**
	 * The unique ID of the FlowNode, as it is modeled in the diagram.
	 */
	@NonNull private String flowNodeId;
	
	/**
	 * The name of the FlowNode, as it is modeled in the diagram.
	 */
	private String flowNodeName;
	
	/**
	 * The lane that this FlowNodeInstance belongs to.
	 * The lane also serves as the IAM claim the user needs to have, in order to access this FlowNodeInstance.
	 */
	private String flowNodeLane;
	
	/**
	 * Describes the BPMN type of the FlowNode that this instance is executing.
	 */
	@NonNull private BpmnType flowNodeType;
	
	/**
	 * If the FlowNodeInstance is an Event, this will contain the type of Event (Message, Signal, Timer, etc).
	 * 
	 * If the FlowNodeInstance is a regular Event, this will be undefined.
	 */
	private EventType eventType;
	
	/**
	 * Contains the InstanceId of the FlowNodeInstance that was executed before this one.
	 *
	 * StartEvents never have a predecessor.
	 */
	private String previousFlowNodeInstanceId;
	
	private String parentProcessInstanceId;
	
	@NonNull private FlowNodeInstanceState state;
	
	@NonNull private String processDefinitionId;
	
	@NonNull private String processModelId;
	
	@NonNull private String processInstanceId;
	
	@NonNull private String correlationId;
	
	/**
	 * The token with which the Flow Node Instance was started.
	 */
	@NonNull private HashMap<String, Object> startToken;
	
	/**
	 * The token with which the Flow Node Instance was finished.
	 * Only available for Flow Node Instances with a "finished", "error" or "terminated" state.
	 */
	private HashMap<String, Object> endToken;
	
	@NonNull private String ownerId;
	
	private Error error;
	
	private Date startedAt;
	
	private Date finishedAt;
	
	private FlowNodeInstance triggeredByFlowNodeInstance;
	
	private String multiInstanceMetadataId;
	
	private Object multiInstanceStartToken;
	
	private Object multiInstanceEndToken;
	
	public static enum FlowNodeInstanceState {
		running,
		suspended,
		finished,
		terminated,
		error,
		canceled
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class FlowNodeInstanceList {
		@NonNull private FlowNodeInstance[] flowNodeInstances;
		
		private int totalCount;
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class FlowNodeInstanceMetaInfo {
		@NonNull private String key;
		
		@NonNull private Object value;
	}
	
	public static enum FlowNodeInstanceSortableColumns {
		flowNodeInstanceId,
		flowNodeId,
		flowNodeName,
		flowNodeLane,
		flowNodeType,
		eventType,
		state,
		previousFlowNodeInstanceId,
		parentProcessInstanceId,
		processDefinitionId,
		processModelId,
		processInstanceId,
		correlationId,
		ownerId,
		createdAt,
		finishedAt,
		triggeredByFlowNodeInstance,
	}
	
	public static enum FlowNodeInstanceSortDirection {
		ASC,
		DESC,
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class FlowNodeInstanceSortSettings {
		@NonNull private FlowNodeInstanceSortableColumns sortBy;
		
		private FlowNodeInstanceSortDirection sortDir;
	}
}
