package dataModels.externalTasks;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
/**
 * Describes an error that occurred while processing an External Task.
 */
public class ExternalTaskError extends Throwable {
	/**
	 * The error code of the error.
	 */
	@NonNull private String errorCode;
	
	/**
	 * The error message of the error.
	 */
	@NonNull private String errorMessage;
	
	/**
	 * Additional information about the error.
	 */
	@NonNull private Object errorDetails;
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	/**
	 * For internal use only - A formatted error object representing an ExternalTask error.
	 * Can be used by internal services who don't care if we're dealing with a Service- or BPMN error
	 */
	public static class ExternalTaskReusableError {
		/**
		 * The error code of the error.
		 */
		@NonNull private String code;
		
		/**
		 * The name of the error.
		 */
		private String name;
		
		/**
		 * The error message of the error.
		 */
		private String message;
		
		/**
		 * Additional information about the error.
		 */
		private Object additionalInformation;
	}
}
