package dataModels;

import java.util.HashMap;

import dataModels.processInstance.ProcessInstance;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
/**
 * Describes a Correlation.
 * Correlations are used to group ProcessInstances into context.
 */
public class Correlation {
	/**
	 * The id of the correlation.
	 */
	@NonNull private String correlationId;
	
	/**
	 * Metadata for the correlation.
	 */
	private CorrelationMetadata metadata;
	
	/**
	 * The process instances that run in the context of this correlation.
	 */
	private ProcessInstance[] processInstances;
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	/**
	 * A list of Correlations.
	 */
	public static class CorrelationList {
		/**
		 * The correlations
		 */
		@NonNull private Correlation[] correlations;
		
		/**
		 * The total number of correlations
		 */
		private int totalCount;
	}
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class CorrelationSortSettings {
		@NonNull private CorrelationSortableColumns sortBy;
		@NonNull private SortDir sortDir;
	}
	
	/**
	 * Metadata for a correlation.
	 */
	public static class CorrelationMetadata extends HashMap<String, String> {

		private static final long serialVersionUID = 694085912086578141L;

	}
	
	public static enum CorrelationSortableColumns {
		correlationId,
		createdAt
	}
	
	public static enum SortDir {
		ASC,
		DESC
	}
}
