package dataModels;

import java.util.HashMap;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
/**
 * Contains basic information about the running application.
 */
public class ApplicationInfo {
	/**
	 * The id of the application.
	 */
	private String id;
	
	/**
	 * The name of the application.
	 */
	@NonNull private String name;
	
	/**
	 * The name of the package the application is running in.
	 */
	@NonNull private String packageName;
	
	/**
	 * The version of the application.
	 */
	@NonNull private String version;
	
	/**
	 * The URL of the IdentityServer that is used for authentication.
	 */
	@NonNull private String authorityUrl;
	
	/**
	 * Flag indicating whether or not anonymous users are allowed to access the root route.
	 */
	private boolean allowAnonymousRootAccess;
	
	/**
	 * Contains the name and version of all loaded extensions.
	 */
	@NonNull private LoadedExtension[] loadedExtensions;
	
	/**
	 * Contains additional information about the application.
	 */
	@NonNull private HashMap<String, Object> extraInfo;
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class LoadedExtension {
		@NonNull private String name;
		@NonNull private String version;
	}
}
