package clients;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import clients.InternalHttpClient.RequestOptions;
import dataModels.ApplicationInfo;
import dataModels.iam.Identity;
import extensionAdapter.IApplicationInfoExtensionAdapter;
import lib.SocketIoManager;
import lombok.NonNull;
import types.RestSettings;

public class ApplicationInfoHttpClient extends BaseClient implements IApplicationInfoExtensionAdapter {
	ApplicationInfoHttpClient(@NonNull URI engineUrl, @NonNull Identity identity, SocketIoManager socketIoManager) throws UnknownHostException, URISyntaxException {
		super(engineUrl, identity, socketIoManager);
	}
	
	@Override
	public CompletableFuture<ApplicationInfo> getApplicationInfo() {
		List<String> requestAuthHeaders = this.createRequestAuthHeaders(this.identity);
		
		URI url = this.buildUrl(RestSettings.Paths.getApplicationInfo, 0, 0, null, null);

		CompletableFuture<HttpResponse<ApplicationInfo>> httpResponse = this.httpClient.get(
				url,
				RequestOptions.builder()
					.headers(requestAuthHeaders)
					.build(),
				ApplicationInfo.class);
		
		return httpResponse.<ApplicationInfo>thenApply((HttpResponse<ApplicationInfo> result) -> result.body());
	}

	@Override
	public CompletableFuture<URI> getAuthorityAddress() {
		List<String> requestAuthHeaders = this.createRequestAuthHeaders(this.identity);
		
		URI url = this.buildUrl(RestSettings.Paths.getAuthorityAddress, 0, 0, null, null);
		
		CompletableFuture<HttpResponse<URI>> httpResponse = this.httpClient.get(
				url,
				RequestOptions.builder()
					.headers(requestAuthHeaders)
					.build(),
				URI.class);
		
		return httpResponse.<URI>thenApply((HttpResponse<URI> result) -> result.body());
	}

//  TODO: Fix SocketIoManager
//	public Subscription onConnected(Listener callback, Boolean subscribeOnce, Identity identity) throws UnauthorizedError, URISyntaxException {
//		return this.createSocketIoSubscription("connect", callback, subscribeOnce, identity);
//	}
//
//	public Subscription onDisconnected(Listener callback, Boolean subscribeOnce, Identity identity) throws UnauthorizedError, URISyntaxException {
//		return this.createSocketIoSubscription("disconnect", callback, subscribeOnce, identity);
//	}
//
//	public Subscription onReconnected(Listener callback, Boolean subscribeOnce, Identity identity) throws UnauthorizedError, URISyntaxException {
//		return this.createSocketIoSubscription("reconnect", callback, subscribeOnce, identity);
//	}

}
