/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.websocket.responses.parsers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de._125m125.kt.ktapi.websocket.responses.ResponseMessage;
import de._125m125.kt.ktapi.websocket.responses.SessionResponse;
import de._125m125.kt.ktapi.websocket.responses.UpdateNotification;
import java.util.Optional;

public class MessageParser {
    public Optional<Object> parse(String message) {
        JsonElement parse = new JsonParser().parse(message);
        if (parse instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)parse;
            if (jsonObject.has("rid")) {
                if (jsonObject.has("session")) {
                    return Optional.of(new Gson().fromJson((JsonElement)jsonObject, SessionResponse.class));
                }
                return Optional.of(new Gson().fromJson((JsonElement)jsonObject, ResponseMessage.class));
            }
            if (jsonObject.has("type") && "update".equals(jsonObject.get("type").getAsString())) {
                return Optional.of(new Gson().fromJson((JsonElement)jsonObject, UpdateNotification.class));
            }
        }
        return Optional.empty();
    }
}

