/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.websocket.requests;

import de._125m125.kt.ktapi.websocket.responses.ResponseMessage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class WebsocketResult {
    private final CompletableFuture<ResponseMessage> result = new CompletableFuture();

    public ResponseMessage get() throws InterruptedException {
        try {
            return this.result.get();
        }
        catch (ExecutionException e) {
            return new ResponseMessage("retrieval of result failed", e);
        }
    }

    public ResponseMessage get(long maxWait, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            return this.result.get(maxWait, unit);
        }
        catch (ExecutionException e) {
            return new ResponseMessage("retrieval of result failed", e);
        }
    }

    public synchronized void addCallback(Consumer<ResponseMessage> consumer) {
        this.result.thenAccept(consumer::accept);
    }

    public synchronized void setResponse(ResponseMessage responseMessage) {
        this.result.complete(responseMessage);
    }

    public synchronized boolean isDone() {
        return this.result.isDone();
    }
}

