/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.websocket.requests;

import com.google.gson.Gson;
import de._125m125.kt.ktapi.websocket.requests.SessionRequestData;
import de._125m125.kt.ktapi.websocket.requests.SubscriptionRequestData;
import de._125m125.kt.ktapi.websocket.requests.WebsocketResult;
import de._125m125.kt.ktapi.websocket.responses.ResponseMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class RequestMessage {
    private final Map<String, Object> content;
    private final WebsocketResult result;

    public static RequestMessageBuilder builder() {
        return new RequestMessageBuilder();
    }

    protected RequestMessage(Map<String, Object> content, WebsocketResult result) {
        this.content = content;
        this.result = result;
    }

    public String getMessage() {
        return new Gson().toJson(this.content);
    }

    public Optional<Integer> getRequestId() {
        return Optional.ofNullable((Integer)this.content.get("rid"));
    }

    public WebsocketResult getResult() {
        return this.result;
    }

    public boolean hasContent(String key) {
        return this.content.containsKey(key);
    }

    public static class RequestMessageBuilder {
        private static final AtomicInteger nextRequestId = new AtomicInteger(0);
        private final Map<String, Object> content;
        private final WebsocketResult result;

        public RequestMessageBuilder(RequestMessage r) {
            this.content = new HashMap<String, Object>(r.content);
            this.result = r.result;
        }

        public RequestMessageBuilder() {
            this.content = new HashMap<String, Object>();
            this.result = new WebsocketResult();
        }

        public RequestMessageBuilder addContent(String key, Object value) {
            if ("rid".equals(key) && !(value instanceof Integer)) {
                throw new IllegalArgumentException("The request id has to be an integer");
            }
            this.content.put(key, value);
            return this;
        }

        public RequestMessageBuilder addContent(SessionRequestData sessionRequest) {
            this.addContent("session", sessionRequest);
            return this;
        }

        public RequestMessageBuilder addContent(SubscriptionRequestData subscriptionRequest) {
            this.addContent("subscribe", subscriptionRequest);
            return this;
        }

        public RequestMessageBuilder addPing() {
            this.addContent("ping", "ping");
            return this;
        }

        public RequestMessageBuilder addResponseCallback(Consumer<ResponseMessage> responseReceiver) {
            this.expectResponse();
            this.result.addCallback(responseReceiver);
            return this;
        }

        public RequestMessageBuilder expectResponse() {
            this.content.computeIfAbsent("rid", k -> nextRequestId.getAndIncrement());
            return this;
        }

        public RequestMessage build() {
            return new RequestMessage(this.content, this.result);
        }
    }
}

