/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.websocket.events.listeners;

import de._125m125.kt.ktapi.websocket.KtWebsocketManager;
import de._125m125.kt.ktapi.websocket.events.BeforeMessageSendEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketConnectedEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketDisconnectedEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketEventListening;
import de._125m125.kt.ktapi.websocket.events.WebsocketManagerCreatedEvent;
import de._125m125.kt.ktapi.websocket.exceptions.MessageSendException;
import de._125m125.kt.ktapi.websocket.requests.RequestMessage;
import de._125m125.kt.ktapi.websocket.requests.SessionRequestData;
import de._125m125.kt.ktapi.websocket.responses.ResponseMessage;
import de._125m125.kt.ktapi.websocket.responses.SessionResponse;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SessionHandler {
    private KtWebsocketManager manager;
    private ScheduledExecutorService service;
    private String sessionId;
    private boolean sessionActive = false;

    @WebsocketEventListening
    public synchronized void onWebsocketManagerCreated(WebsocketManagerCreatedEvent e) {
        if (this.manager != null) {
            throw new IllegalStateException("each session handler can only be used for a single WebsocketManager");
        }
        this.manager = e.getManager();
        this.service = Executors.newScheduledThreadPool(1, r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });
        this.service.scheduleAtFixedRate(this::pingSession, 1L, 1L, TimeUnit.HOURS);
    }

    @WebsocketEventListening
    public void onWebsocketConnected(WebsocketConnectedEvent e) {
        this.resumeSession();
    }

    @WebsocketEventListening
    public synchronized void onWebsocketDisconnected(WebsocketDisconnectedEvent e) {
        this.sessionActive = false;
    }

    @WebsocketEventListening
    public void onBeforeMessageSend(BeforeMessageSendEvent e) {
        if (e.getMessage().hasContent("subscribe")) {
            this.checkSession();
        }
    }

    private synchronized void checkSession() {
        if (this.sessionActive) {
            return;
        }
        RequestMessage requestMessage = RequestMessage.builder().addContent(SessionRequestData.createStartRequest()).build();
        this.manager.sendRequest(requestMessage);
        try {
            ResponseMessage responseMessage = requestMessage.getResult().get(5L, TimeUnit.SECONDS);
            if (!(responseMessage instanceof SessionResponse)) {
                return;
            }
            this.sessionId = ((SessionResponse)responseMessage).getSessionDetails().getId();
            this.sessionActive = true;
        }
        catch (InterruptedException | TimeoutException e) {
            return;
        }
    }

    private synchronized boolean resumeSession() {
        block4: {
            if (this.sessionId == null || this.sessionActive) {
                return true;
            }
            RequestMessage requestMessage = RequestMessage.builder().addContent(SessionRequestData.createResumtionRequest(this.sessionId)).build();
            this.manager.sendRequest(requestMessage);
            ResponseMessage responseMessage = requestMessage.getResult().get(30L, TimeUnit.SECONDS);
            boolean error = responseMessage.getError().filter("unknownSessionId"::equals).isPresent();
            if (!error) break block4;
            this.sessionId = null;
            return false;
        }
        try {
            this.sessionActive = true;
            return true;
        }
        catch (InterruptedException | TimeoutException e) {
            return false;
        }
    }

    public synchronized void pingSession() {
        if (!this.sessionActive) {
            return;
        }
        try {
            this.manager.sendMessage(new RequestMessage.RequestMessageBuilder().addContent(SessionRequestData.createStatusRequest()).build());
        }
        catch (MessageSendException e) {
            this.service.schedule(this::pingSession, 1L, TimeUnit.MINUTES);
        }
    }
}

