/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.websocket.events.listeners;

import de._125m125.kt.ktapi.websocket.KtWebsocketManager;
import de._125m125.kt.ktapi.websocket.events.BeforeMessageSendEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketConnectedEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketEventListening;
import de._125m125.kt.ktapi.websocket.events.WebsocketManagerCreatedEvent;
import de._125m125.kt.ktapi.websocket.requests.RequestMessage;
import java.util.ArrayList;
import java.util.List;

public class OfflineMessageHandler {
    private KtWebsocketManager manager;
    private final List<RequestMessage> waitingRequests = new ArrayList<RequestMessage>();

    @WebsocketEventListening
    public synchronized void onWebsocketManagerCreated(WebsocketManagerCreatedEvent e) {
        if (this.manager != null) {
            throw new IllegalStateException("each session handler can only be used for a single WebsocketManager");
        }
        this.manager = e.getManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebsocketEventListening
    public void beforeMessageSend(BeforeMessageSendEvent e) {
        if (!e.getWebsocketStatus().isConnected()) {
            List<RequestMessage> list = this.waitingRequests;
            synchronized (list) {
                this.waitingRequests.add(e.getMessage());
            }
            e.softCancel();
        }
    }

    @WebsocketEventListening
    public void onWebsocketConnect(WebsocketConnectedEvent e) {
        new Thread(() -> {
            ArrayList<RequestMessage> oldMessages;
            List<RequestMessage> list = this.waitingRequests;
            synchronized (list) {
                oldMessages = new ArrayList<RequestMessage>(this.waitingRequests);
                this.waitingRequests.clear();
            }
            oldMessages.forEach(this.manager::sendMessage);
        }, "ResendCapturedOfflineMessageThread").start();
    }
}

