/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.websocket.events.listeners;

import de._125m125.kt.ktapi.core.KtNotificationManager;
import de._125m125.kt.ktapi.core.NotificationListener;
import de._125m125.kt.ktapi.core.users.KtUserStore;
import de._125m125.kt.ktapi.core.users.TokenUser;
import de._125m125.kt.ktapi.core.users.TokenUserKey;
import de._125m125.kt.ktapi.core.users.UserKey;
import de._125m125.kt.ktapi.websocket.KtWebsocketManager;
import de._125m125.kt.ktapi.websocket.SubscriptionList;
import de._125m125.kt.ktapi.websocket.events.MessageReceivedEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketEventListening;
import de._125m125.kt.ktapi.websocket.events.WebsocketManagerCreatedEvent;
import de._125m125.kt.ktapi.websocket.exceptions.SubscriptionRefusedException;
import de._125m125.kt.ktapi.websocket.requests.RequestMessage;
import de._125m125.kt.ktapi.websocket.requests.SubscriptionRequestData;
import de._125m125.kt.ktapi.websocket.responses.UpdateNotification;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class KtWebsocketNotificationHandler<T extends TokenUserKey>
implements KtNotificationManager<T> {
    private KtWebsocketManager manager;
    private final Map<String, Map<String, SubscriptionList>> subscriptions = new HashMap<String, Map<String, SubscriptionList>>();
    private final KtUserStore userStore;

    public KtWebsocketNotificationHandler(KtUserStore userStore) {
        this.userStore = userStore;
    }

    @WebsocketEventListening
    public synchronized void onWebsocketManagerCreated(WebsocketManagerCreatedEvent e) {
        if (this.manager != null) {
            throw new IllegalStateException("each session handler can only be used for a single WebsocketManager");
        }
        this.manager = e.getManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebsocketEventListening
    public void onMessageReceived(MessageReceivedEvent e) {
        if (e.getMessage() instanceof UpdateNotification) {
            SubscriptionList keyList = null;
            SubscriptionList unkeyedList = null;
            UpdateNotification notificationMessage = (UpdateNotification)((Object)e.getMessage());
            Map<String, Map<String, SubscriptionList>> map = this.subscriptions;
            synchronized (map) {
                Map<String, SubscriptionList> sourceMap = this.subscriptions.get(notificationMessage.getSource());
                if (sourceMap != null) {
                    keyList = sourceMap.get(notificationMessage.getKey());
                    unkeyedList = sourceMap.get(null);
                }
            }
            if (keyList != null) {
                keyList.notifyListeners(notificationMessage);
            }
            if (unkeyedList != null) {
                unkeyedList.notifyListeners(notificationMessage);
            }
        }
    }

    public CompletableFuture<NotificationListener> subscribeToMessages(NotificationListener listener, T userKey, boolean selfCreated) {
        SubscriptionRequestData request = new SubscriptionRequestData("rMessages", (TokenUser)this.userStore.get(userKey), selfCreated);
        return this.subscribe(request, "messages", userKey.getUserId(), userKey, listener);
    }

    public CompletableFuture<NotificationListener> subscribeToTrades(NotificationListener listener, T userKey, boolean selfCreated) {
        SubscriptionRequestData request = new SubscriptionRequestData("rOrders", (TokenUser)this.userStore.get(userKey), selfCreated);
        return this.subscribe(request, "trades", userKey.getUserId(), userKey, listener);
    }

    public CompletableFuture<NotificationListener> subscribeToItems(NotificationListener listener, T userKey, boolean selfCreated) {
        System.out.println(this.userStore.get(userKey));
        SubscriptionRequestData request = new SubscriptionRequestData("rItems", (TokenUser)this.userStore.get(userKey), selfCreated);
        return this.subscribe(request, "items", userKey.getUserId(), userKey, listener);
    }

    public CompletableFuture<NotificationListener> subscribeToPayouts(NotificationListener listener, T userKey, boolean selfCreated) {
        SubscriptionRequestData request = new SubscriptionRequestData("rPayouts", (TokenUser)this.userStore.get(userKey), selfCreated);
        return this.subscribe(request, "payouts", userKey.getUserId(), userKey, listener);
    }

    public CompletableFuture<NotificationListener> subscribeToOrderbook(NotificationListener listener) {
        SubscriptionRequestData request = new SubscriptionRequestData("orderbook");
        return this.subscribe(request, "orderbook", null, null, listener);
    }

    public CompletableFuture<NotificationListener> subscribeToHistory(NotificationListener listener) {
        SubscriptionRequestData request = new SubscriptionRequestData("history");
        return this.subscribe(request, "history", null, null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<NotificationListener> subscribe(SubscriptionRequestData request, String source, String key, T owner, NotificationListener listener) {
        CompletableFuture<NotificationListener> result = new CompletableFuture<NotificationListener>();
        try {
            KtWebsocketManager manager = this.manager;
            if (manager == null) {
                KtWebsocketNotificationHandler ktWebsocketNotificationHandler = this;
                synchronized (ktWebsocketNotificationHandler) {
                    manager = this.manager;
                }
            }
            if (manager == null) {
                throw new IllegalStateException("the notification manager first has to be assigned to a KtWebsocketmanager");
            }
            RequestMessage requestMessage = RequestMessage.builder().addContent(request).build();
            this.manager.sendRequest(requestMessage);
            requestMessage.getResult().addCallback(responseMessage -> {
                if (responseMessage.success()) {
                    SubscriptionList subList;
                    Map<String, Map<String, SubscriptionList>> map = this.subscriptions;
                    synchronized (map) {
                        subList = this.subscriptions.computeIfAbsent(source, n -> new HashMap()).computeIfAbsent(key, n -> new SubscriptionList((TokenUser)this.userStore.get((UserKey)owner)));
                    }
                    subList.addListener(listener, request.isSelfCreated());
                    result.complete(listener);
                } else {
                    Throwable exception = responseMessage.getErrorCause().orElseGet(() -> new SubscriptionRefusedException(responseMessage.getError().orElse("unknown")));
                    result.completeExceptionally(exception);
                }
            });
        }
        catch (Throwable th) {
            result.completeExceptionally(th);
        }
        return result;
    }

    public void disconnect() {
        this.manager.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(NotificationListener listener) {
        Map<String, Map<String, SubscriptionList>> map = this.subscriptions;
        synchronized (map) {
            this.subscriptions.values().forEach(m -> m.values().forEach(sl -> sl.removeListener(listener)));
        }
    }
}

