/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.websocket.events.listeners;

import de._125m125.kt.ktapi.websocket.KtWebsocketManager;
import de._125m125.kt.ktapi.websocket.events.WebsocketConnectedEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketDisconnectedEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketEventListening;
import de._125m125.kt.ktapi.websocket.events.WebsocketManagerCreatedEvent;

public class AutoReconnectionHandler {
    private Thread restart_wait_thread;
    private long lastDelay;
    private KtWebsocketManager manager;

    @WebsocketEventListening
    public synchronized void onWebsocketManagerCreated(WebsocketManagerCreatedEvent e) {
        if (this.manager != null) {
            throw new IllegalStateException("each reconnection handler can only be used for a single WebsocketManager");
        }
        this.manager = e.getManager();
    }

    @WebsocketEventListening
    public synchronized void onWebsocketConnected(WebsocketConnectedEvent e) {
        this.lastDelay = 0L;
        if (this.restart_wait_thread != null) {
            this.restart_wait_thread.interrupt();
        }
    }

    @WebsocketEventListening
    public void onWebsocketDisconnected(WebsocketDisconnectedEvent e) {
        if (e.getWebsocketStatus().isActive()) {
            this.reConnectDelayed();
        }
    }

    private synchronized void reConnectDelayed() {
        if (this.restart_wait_thread != null && this.restart_wait_thread.isAlive() && this.restart_wait_thread != Thread.currentThread()) {
            throw new IllegalStateException("this instance is already waiting for a reconnect");
        }
        this.restart_wait_thread = new Thread(() -> {
            this.lastDelay = this.lastDelay != 0L ? this.lastDelay * 2L : 1000L;
            System.out.println(this.lastDelay);
            try {
                Thread.sleep(this.lastDelay);
                this.manager.connect();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.restart_wait_thread.setDaemon(false);
        this.restart_wait_thread.start();
    }
}

