/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.websocket;

import de._125m125.kt.ktapi.core.NotificationListener;
import de._125m125.kt.ktapi.core.entities.Notification;
import de._125m125.kt.ktapi.core.users.TokenUser;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class SubscriptionList {
    private final List<NotificationListener> otherListeners;
    private final List<NotificationListener> selfListeners;
    private Optional<TokenUser> owner;

    public SubscriptionList() {
        this(null);
    }

    public SubscriptionList(TokenUser u) {
        this.owner = Optional.ofNullable(u);
        this.otherListeners = new CopyOnWriteArrayList<NotificationListener>();
        this.selfListeners = new CopyOnWriteArrayList<NotificationListener>();
    }

    public void setOwner(TokenUser u) {
        this.owner = Optional.of(u);
    }

    public void addListener(NotificationListener l, boolean selfCreated) {
        if (selfCreated) {
            this.selfListeners.add(l);
        } else {
            this.otherListeners.add(l);
        }
    }

    public void notifyListeners(Notification notification) {
        for (NotificationListener nl : notification.isSelfCreated() ? this.selfListeners : this.otherListeners) {
            nl.update(notification);
        }
    }

    public Optional<TokenUser> getOwner() {
        return this.owner;
    }

    public void removeListener(NotificationListener listener) {
        this.otherListeners.remove(listener);
        this.selfListeners.remove(listener);
    }
}

