/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.websocket;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de._125m125.kt.ktapi.websocket.KtWebsocket;
import de._125m125.kt.ktapi.websocket.events.AfterMessageSendEvent;
import de._125m125.kt.ktapi.websocket.events.BeforeMessageSendEvent;
import de._125m125.kt.ktapi.websocket.events.CancelableWebsocketEvent;
import de._125m125.kt.ktapi.websocket.events.MessageDeliveryFailedEvent;
import de._125m125.kt.ktapi.websocket.events.MessageReceivedEvent;
import de._125m125.kt.ktapi.websocket.events.UnparsableMessageEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketConnectedEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketDisconnectedEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketEventListening;
import de._125m125.kt.ktapi.websocket.events.WebsocketManagerCreatedEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketStartedEvent;
import de._125m125.kt.ktapi.websocket.events.WebsocketStatus;
import de._125m125.kt.ktapi.websocket.events.WebsocketStoppedEvent;
import de._125m125.kt.ktapi.websocket.exceptions.MessageCancelException;
import de._125m125.kt.ktapi.websocket.exceptions.MessageSendException;
import de._125m125.kt.ktapi.websocket.requests.RequestMessage;
import de._125m125.kt.ktapi.websocket.requests.WebsocketResult;
import de._125m125.kt.ktapi.websocket.responses.ResponseMessage;
import de._125m125.kt.ktapi.websocket.responses.parsers.NotificationParser;
import de._125m125.kt.ktapi.websocket.responses.parsers.ResponseMessageParser;
import de._125m125.kt.ktapi.websocket.responses.parsers.SessionMessageParser;
import de._125m125.kt.ktapi.websocket.responses.parsers.WebsocketMessageParser;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class KtWebsocketManager
implements Closeable {
    private final Map<Class<? extends WebsocketEvent>, List<Consumer<Object>>> listeners;
    private final List<WebsocketMessageParser<?>> parsers;
    private final KtWebsocket websocket;
    protected volatile boolean active = false;
    protected volatile boolean connected = false;
    private final Map<Integer, RequestMessage> awaitedResponses = new ConcurrentHashMap<Integer, RequestMessage>();

    public static Builder builder(KtWebsocket websocket) {
        return new Builder(websocket);
    }

    public KtWebsocketManager(Map<Class<? extends WebsocketEvent>, List<Consumer<Object>>> listeners, List<WebsocketMessageParser<?>> parsers, KtWebsocket websocket) {
        this.listeners = listeners;
        this.parsers = parsers;
        this.websocket = websocket;
    }

    public <T extends WebsocketEvent> void fireEvent(T e) {
        List<Consumer<Object>> consumers = this.listeners.get(e.getClass());
        if (consumers == null) {
            return;
        }
        for (Consumer<Object> consumer : consumers) {
            if (e instanceof CancelableWebsocketEvent && ((CancelableWebsocketEvent)e).isCancelled()) break;
            consumer.accept(e);
        }
    }

    public void sendMessage(RequestMessage requestMessage) throws MessageSendException {
        System.out.println("sending " + requestMessage.getMessage());
        BeforeMessageSendEvent bmse = new BeforeMessageSendEvent(this.generateStatus(), requestMessage);
        this.fireEvent(bmse);
        if (bmse.isCancelled()) {
            if (bmse.getCancelState() == CancelableWebsocketEvent.CancelState.HARD) {
                throw new MessageCancelException(bmse.getCancelReason());
            }
            return;
        }
        requestMessage.getRequestId().ifPresent(rid -> {
            RequestMessage requestMessage2 = this.awaitedResponses.put((Integer)rid, requestMessage);
        });
        try {
            this.websocket.sendMessage(requestMessage.getMessage());
        }
        catch (IOException e) {
            MessageDeliveryFailedEvent mdfe = new MessageDeliveryFailedEvent(this.generateStatus(), requestMessage, e);
            this.fireEvent(mdfe);
            if (mdfe.isCancelled()) {
                return;
            }
            requestMessage.getResult().setResponse(new ResponseMessage("message delivery failed", e));
            requestMessage.getRequestId().ifPresent(this.awaitedResponses::remove);
            return;
        }
        this.fireEvent(new AfterMessageSendEvent(this.generateStatus(), requestMessage));
    }

    public void sendRequest(RequestMessage requestMessage) throws MessageSendException {
        if (requestMessage.getRequestId().isPresent()) {
            this.sendMessage(requestMessage);
        } else {
            this.sendMessage(new RequestMessage.RequestMessageBuilder(requestMessage).expectResponse().build());
        }
    }

    public void receiveMessage(String rawMessage) {
        System.out.println("received " + rawMessage);
        Optional<JsonObject> json = this.tryParse(rawMessage);
        Optional<WebsocketMessageParser> parser = this.parsers.stream().filter(p -> p.parses(rawMessage, json)).findFirst();
        if (parser.isPresent()) {
            Object parsedResponse = parser.get().parse(rawMessage, json);
            if (parsedResponse instanceof ResponseMessage) {
                ResponseMessage responseMessage = (ResponseMessage)parsedResponse;
                responseMessage.getRequestId().map(this.awaitedResponses::remove).map(RequestMessage::getResult).filter(r -> !r.isDone()).ifPresent(r -> r.setResponse(responseMessage));
            }
            this.fireEvent(new MessageReceivedEvent(this.generateStatus(), parsedResponse));
        } else {
            this.fireEvent(new UnparsableMessageEvent(this.generateStatus(), rawMessage, json));
        }
    }

    public void websocketDisconnected() {
        this.connected = false;
        this.cancelAwaitedResponses();
        this.fireEvent(new WebsocketDisconnectedEvent(this.generateStatus()));
    }

    public void websocketConnected() {
        this.connected = true;
        this.fireEvent(new WebsocketConnectedEvent(this.generateStatus()));
    }

    @Override
    public void close() {
        this.stop();
    }

    public void stop() {
        this.connected = false;
        this.active = false;
        this.websocket.close();
        this.fireEvent(new WebsocketStoppedEvent(this.generateStatus()));
    }

    public void open() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.fireEvent(new WebsocketStartedEvent(this.generateStatus()));
        this.connect();
    }

    public void connect() {
        if (!this.active) {
            throw new IllegalStateException("cannot connect websocket while inactive");
        }
        this.websocket.connect();
    }

    private void cancelAwaitedResponses() {
        Iterator<Map.Entry<Integer, RequestMessage>> iterator = this.awaitedResponses.entrySet().iterator();
        while (iterator.hasNext()) {
            WebsocketResult result = iterator.next().getValue().getResult();
            if (!result.isDone()) {
                result.setResponse(new ResponseMessage("websocket closed", null));
            }
            iterator.remove();
        }
    }

    private Optional<JsonObject> tryParse(String rawMessage) {
        try {
            JsonElement parse = new JsonParser().parse(rawMessage);
            if (parse instanceof JsonObject) {
                return Optional.of((JsonObject)parse);
            }
            return Optional.empty();
        }
        catch (JsonParseException e) {
            return Optional.empty();
        }
    }

    private WebsocketStatus generateStatus() {
        return new WebsocketStatus(this.active, this.connected);
    }

    public static class Builder {
        private final KtWebsocket websocket;
        private final Map<Class<? extends WebsocketEvent>, List<Consumer<Object>>> listeners = new HashMap<Class<? extends WebsocketEvent>, List<Consumer<Object>>>();
        private final List<WebsocketMessageParser<?>> parsers = new ArrayList();

        public Builder(KtWebsocket websocket) {
            this.websocket = websocket;
        }

        public <T extends WebsocketEvent> Builder addListener(Class<T> clazz, Consumer<? super T> consumer) {
            this.listeners.computeIfAbsent(clazz, c -> new ArrayList()).add(o -> consumer.accept((Object)clazz.cast(o)));
            return this;
        }

        public Builder addListener(Object listener) {
            Method[] methods;
            Method[] methodArray = methods = listener.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getAnnotation(WebsocketEventListening.class) != null) {
                    Parameter[] parameters = m.getParameters();
                    if (parameters.length != 1) {
                        throw new IllegalArgumentException("Method " + m.getName() + " should have exactly one argument");
                    }
                    Parameter p = parameters[0];
                    if (!WebsocketEvent.class.isAssignableFrom(p.getType())) {
                        throw new IllegalArgumentException("The argument for " + listener.getClass().getName() + "#" + m.getName() + " does not extend WebsocketEvent");
                    }
                    this.addListener(p.getType(), t -> {
                        try {
                            m.invoke(listener, t);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (e.getCause() instanceof RuntimeException) {
                                throw (RuntimeException)e.getCause();
                            }
                            throw new RuntimeException(cause);
                        }
                    });
                }
                ++n2;
            }
            return this;
        }

        public Builder addDefaultParsers() {
            this.addParser(new NotificationParser());
            this.addParser(new SessionMessageParser());
            this.addParser(new ResponseMessageParser());
            return this;
        }

        public <T> Builder addParser(WebsocketMessageParser<T> parser) {
            this.parsers.add(parser);
            return this;
        }

        public KtWebsocketManager build() {
            KtWebsocketManager manager = new KtWebsocketManager(this.listeners, this.parsers, this.websocket);
            this.websocket.setManager(manager);
            manager.fireEvent(new WebsocketManagerCreatedEvent(manager));
            return manager;
        }

        public KtWebsocketManager buildAndOpen() {
            KtWebsocketManager build = this.build();
            build.open();
            return build;
        }
    }
}

