/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.retrofitRequester.builderModifier;

import de._125m125.kt.ktapi.retrofitRequester.builderModifier.ClientModifier;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class HeaderAdder
implements ClientModifier {
    private final String name;
    private final HeaderProducer valueProducer;

    public HeaderAdder(String name, String value) {
        this(name, (Request r) -> value);
    }

    public HeaderAdder(String name, HeaderProducer valueProducer) {
        this.name = name;
        this.valueProducer = valueProducer;
    }

    @Override
    public OkHttpClient.Builder modify(OkHttpClient.Builder builder) {
        return builder.addInterceptor(chain -> {
            String value = this.valueProducer.apply(chain.request());
            Request request = chain.request();
            if (value != null) {
                request = chain.request().newBuilder().addHeader(this.name, value).build();
            }
            return chain.proceed(request);
        });
    }

    public static interface HeaderProducer {
        public String apply(Request var1) throws IOException;
    }
}

