/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.retrofitRequester.builderModifier;

import de._125m125.kt.ktapi.retrofitRequester.builderModifier.ClientModifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;

public class ClientCertificateAdder
implements ClientModifier {
    private static final Optional<X509TrustManager> DEFAULT_TRUST_MANAGER;
    private final SSLSocketFactory socketFactory;
    private final X509TrustManager trustManager;

    static {
        Optional<Object> tmp = Optional.empty();
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            tmp = Arrays.stream(trustManagerFactory.getTrustManagers()).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findAny();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        DEFAULT_TRUST_MANAGER = tmp;
    }

    public static ClientModifier createUnchecked(File pkcs12File, char[] filePassword) {
        try {
            return new ClientCertificateAdder(pkcs12File, filePassword);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException | UnrecoverableKeyException | CertificateException e) {
            throw new IllegalArgumentException("Invalid Certificate");
        }
    }

    public static ClientModifier createUnchecked(File pkcs12File, char[] filePassword, X509TrustManager trustManager) {
        try {
            return new ClientCertificateAdder(pkcs12File, filePassword, trustManager);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException | UnrecoverableKeyException | CertificateException e) {
            throw new IllegalArgumentException("Invalid Certificate");
        }
    }

    public ClientCertificateAdder(File pkcs12File, char[] password) throws NoSuchAlgorithmException, KeyStoreException, FileNotFoundException, IOException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        if (!DEFAULT_TRUST_MANAGER.isPresent()) {
            throw new IllegalStateException("no default trust manager is present.");
        }
        this.trustManager = DEFAULT_TRUST_MANAGER.get();
        this.socketFactory = this.createSocketFactory(pkcs12File, password);
    }

    public ClientCertificateAdder(File pkcs12File, char[] password, X509TrustManager trustmanager) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        this.trustManager = trustmanager;
        this.socketFactory = this.createSocketFactory(pkcs12File, password);
    }

    private SSLSocketFactory createSocketFactory(File pkcs12File, char[] password) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileInputStream keyInput = new FileInputStream(pkcs12File);){
            keyStore.load(keyInput, password);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        keyManagerFactory.init(keyStore, password);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagerFactory.getKeyManagers(), new TrustManager[]{this.trustManager}, new SecureRandom());
        return context.getSocketFactory();
    }

    @Override
    public OkHttpClient.Builder modify(OkHttpClient.Builder builder) {
        return builder.sslSocketFactory(this.socketFactory, this.trustManager);
    }
}

