/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.retrofitRequester.builderModifier;

import de._125m125.kt.ktapi.retrofitRequester.builderModifier.ClientModifier;
import okhttp3.CertificatePinner;
import okhttp3.OkHttpClient;

public class CertificatePinnerAdder
implements ClientModifier {
    public static CertificatePinnerAdderCertificate[] DEFAULT_CERTIFICATES = new CertificatePinnerAdderCertificate[]{new CertificatePinnerAdderCertificate("kt.125m125.de", "sha256/ZnHPNFeZ/okzKy3UttEwn4O9V8T/qEvByGaE1FLBdq8=", "sha256/tcgiMrn7yiqTpt7SDna6sU0faF8m4QUiq24aQVW3F9U=", "sha256/Ii0NcQVclBzikUGw+iAV5+UnEmTqQDIhLZifNGM4yHY=")};
    private final CertificatePinner certificatePinner;

    public CertificatePinnerAdder() {
        this(DEFAULT_CERTIFICATES);
    }

    public CertificatePinnerAdder(CertificatePinnerAdderCertificate ... certificates) {
        if (certificates.length == 0 || certificates == null) {
            throw new IllegalArgumentException("CertificatePinnerAdder requires at least contain one certificate to pin");
        }
        CertificatePinner.Builder builder = new CertificatePinner.Builder();
        CertificatePinnerAdderCertificate[] certificatePinnerAdderCertificateArray = certificates;
        int n = certificates.length;
        int n2 = 0;
        while (n2 < n) {
            CertificatePinnerAdderCertificate certificate = certificatePinnerAdderCertificateArray[n2];
            builder.add(certificate.getHostname(), certificate.getValues());
            ++n2;
        }
        this.certificatePinner = builder.build();
    }

    @Override
    public OkHttpClient.Builder modify(OkHttpClient.Builder builder) {
        if (this.certificatePinner != null) {
            builder.certificatePinner(this.certificatePinner);
        }
        return builder;
    }

    public static class CertificatePinnerAdderCertificate {
        private final String hostname;
        private final String[] value;

        public CertificatePinnerAdderCertificate(String hostname, String ... value) {
            this.hostname = hostname;
            this.value = value;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String[] getValues() {
            return this.value;
        }
    }
}

