/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.retrofitRequester.builderModifier;

import de._125m125.kt.ktapi.core.users.KtUserStore;
import de._125m125.kt.ktapi.core.users.TokenUser;
import de._125m125.kt.ktapi.core.users.TokenUserKey;
import de._125m125.kt.ktapi.retrofitRequester.builderModifier.HeaderAdder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import okhttp3.Request;

public class BasicAuthenticator
extends HeaderAdder {
    private static String generateAuthString(KtUserStore userStore, Request r) throws IOException {
        String header = r.header("userKey");
        if (header == null || header.isEmpty()) {
            return null;
        }
        TokenUser user = (TokenUser)userStore.get(header, TokenUserKey.class);
        if (user == null) {
            throw new IOException("user is not contained in the KtUserStore");
        }
        return "Basic " + Base64.getEncoder().encodeToString((String.valueOf(user.getTokenId()) + ":" + user.getToken()).getBytes(Charset.forName("UTF-8")));
    }

    public BasicAuthenticator(KtUserStore userStore) {
        super("Authorization", (Request r) -> BasicAuthenticator.generateAuthString(userStore, r));
    }
}

