/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.retrofitRequester;

import de._125m125.kt.ktapi.core.results.ErrorResponse;
import de._125m125.kt.ktapi.core.results.Result;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;

public class RetrofitResult<T>
extends Result<T> {
    public RetrofitResult(Call<T> call, final Converter<ResponseBody, ErrorResponse> errorConverter) {
        call.enqueue(new Callback<T>(){

            public void onResponse(Call<T> call, Response<T> response) {
                if (response.isSuccessful()) {
                    RetrofitResult.this.setSuccessResult(response.code(), response.body());
                } else {
                    ErrorResponse errorResponse;
                    try {
                        errorResponse = (ErrorResponse)errorConverter.convert((Object)response.errorBody());
                    }
                    catch (Exception e) {
                        try {
                            errorResponse = new ErrorResponse(response.code(), response.errorBody().string(), "An unknown Error occurred");
                        }
                        catch (IOException e1) {
                            errorResponse = new ErrorResponse(response.code(), "unknown : " + e1.toString(), "An unknown Error occurred");
                        }
                    }
                    RetrofitResult.this.setErrorResult(errorResponse);
                }
            }

            public void onFailure(Call<T> call, Throwable t) {
                RetrofitResult.this.setErrorResult(new ErrorResponse(-1, t.toString(), t.getLocalizedMessage()));
            }
        });
    }
}

