/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.retrofitRequester;

import de._125m125.kt.ktapi.core.BUY_SELL;
import de._125m125.kt.ktapi.core.BUY_SELL_BOTH;
import de._125m125.kt.ktapi.core.KtRequester;
import de._125m125.kt.ktapi.core.PAYOUT_TYPE;
import de._125m125.kt.ktapi.core.entities.HistoryEntry;
import de._125m125.kt.ktapi.core.entities.Item;
import de._125m125.kt.ktapi.core.entities.Message;
import de._125m125.kt.ktapi.core.entities.OrderBookEntry;
import de._125m125.kt.ktapi.core.entities.Payout;
import de._125m125.kt.ktapi.core.entities.Permissions;
import de._125m125.kt.ktapi.core.entities.PusherResult;
import de._125m125.kt.ktapi.core.entities.Trade;
import de._125m125.kt.ktapi.core.results.ErrorResponse;
import de._125m125.kt.ktapi.core.results.Result;
import de._125m125.kt.ktapi.core.results.WriteResult;
import de._125m125.kt.ktapi.core.users.UserKey;
import de._125m125.kt.ktapi.retrofitRequester.KtRetrofitClient;
import de._125m125.kt.ktapi.retrofitRequester.RetrofitResult;
import de._125m125.kt.ktapi.retrofitRequester.builderModifier.ClientModifier;
import de._125m125.kt.ktapi.retrofitRequester.builderModifier.RetrofitModifier;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class KtRetrofitRequester<T extends UserKey<?>>
implements KtRequester<T> {
    private final KtRetrofitClient client;
    private final Converter<ResponseBody, ErrorResponse> errorConverter;
    private final OkHttpClient okHttpClient;

    public KtRetrofitRequester(String url, ClientModifier[] clientModifiers, RetrofitModifier[] retrofitModifiers, Converter<ResponseBody, ErrorResponse> errorConverter) {
        int n;
        this.errorConverter = errorConverter;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (clientModifiers != null) {
            ClientModifier[] clientModifierArray = clientModifiers;
            n = clientModifiers.length;
            int n2 = 0;
            while (n2 < n) {
                ClientModifier clientModifier = clientModifierArray[n2];
                clientBuilder = clientModifier.modify(clientBuilder);
                ++n2;
            }
        }
        clientBuilder = clientBuilder.addInterceptor(chain -> {
            Request r = chain.request().newBuilder().removeHeader("userKey").build();
            return chain.proceed(r);
        });
        clientBuilder = clientBuilder.addInterceptor(chain -> {
            Request request = chain.request();
            if (request.method().equals("GET")) {
                return chain.proceed(request);
            }
            if (request.header("content-type") != null) {
                return chain.proceed(request);
            }
            request = request.newBuilder().addHeader("content-type", "application/x-www-form-urlencoded").build();
            return chain.proceed(request);
        });
        this.okHttpClient = clientBuilder.build();
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(url);
        if (retrofitModifiers != null) {
            RetrofitModifier[] retrofitModifierArray = retrofitModifiers;
            int n3 = retrofitModifiers.length;
            n = 0;
            while (n < n3) {
                RetrofitModifier retrofitModifier = retrofitModifierArray[n];
                retrofitBuilder = retrofitModifier.modify(retrofitBuilder);
                ++n;
            }
        }
        this.client = (KtRetrofitClient)retrofitBuilder.client(this.okHttpClient).build().create(KtRetrofitClient.class);
    }

    public void close() {
        this.okHttpClient.connectionPool().evictAll();
        this.okHttpClient.dispatcher().executorService().shutdown();
    }

    public Result<List<HistoryEntry>> getHistory(String itemid, int limit, int offset) {
        return new RetrofitResult<List<HistoryEntry>>(this.client.getHistory(itemid, limit, offset), this.errorConverter);
    }

    public Result<HistoryEntry> getLatestHistory(String itemid) {
        return new RetrofitResult<HistoryEntry>(this.client.getLatestHistory(itemid), this.errorConverter);
    }

    public Result<List<OrderBookEntry>> getOrderBook(String itemid, int limit, BUY_SELL_BOTH mode, boolean summarizeRemaining) {
        return new RetrofitResult<List<OrderBookEntry>>(this.client.getOrderBook(itemid, limit, mode, summarizeRemaining), this.errorConverter);
    }

    public Result<List<OrderBookEntry>> getBestOrderBookEntries(String itemid, BUY_SELL_BOTH mode) {
        return new RetrofitResult<List<OrderBookEntry>>(this.client.getBestOrderBookEntries(itemid, mode), this.errorConverter);
    }

    public Result<Permissions> getPermissions(T userKey) {
        return new RetrofitResult<Permissions>(this.client.getPermissions(userKey.getUserId(), userKey.getIdentifier()), this.errorConverter);
    }

    public Result<List<Item>> getItems(T userKey) {
        return new RetrofitResult<List<Item>>(this.client.getItems(userKey.getUserId(), userKey.getIdentifier()), this.errorConverter);
    }

    public Result<Item> getItem(T userKey, String itemid) {
        return new RetrofitResult<Item>(this.client.getItem(userKey.getUserId(), itemid, userKey.getIdentifier()), this.errorConverter);
    }

    public Result<List<Message>> getMessages(T userKey) {
        return new RetrofitResult<List<Message>>(this.client.getMessages(userKey.getUserId(), userKey.getIdentifier()), this.errorConverter);
    }

    public Result<List<Payout>> getPayouts(T userKey) {
        return new RetrofitResult<List<Payout>>(this.client.getPayouts(userKey.getUserId(), userKey.getIdentifier()), this.errorConverter);
    }

    public Result<WriteResult<Payout>> createPayout(T userKey, PAYOUT_TYPE type, String itemid, String amount) {
        return new RetrofitResult<WriteResult<Payout>>(this.client.createPayout(userKey.getUserId(), type.getComName(), itemid, amount, userKey.getIdentifier()), this.errorConverter);
    }

    public Result<WriteResult<Payout>> cancelPayout(T userKey, long payoutid) {
        return new RetrofitResult<WriteResult<Payout>>(this.client.cancelPayout(userKey.getUserId(), payoutid, userKey.getIdentifier()), this.errorConverter);
    }

    public Result<WriteResult<Payout>> takeoutPayout(T userKey, long payoutid) {
        return new RetrofitResult<WriteResult<Payout>>(this.client.takeoutPayout(userKey.getUserId(), payoutid, userKey.getIdentifier()), this.errorConverter);
    }

    public Result<PusherResult> authorizePusher(T userKey, String channel_name, String socketId) {
        return new RetrofitResult<PusherResult>(this.client.authorizePusher(userKey.getUserId(), channel_name, socketId, userKey.getIdentifier()), this.errorConverter);
    }

    public Result<List<Trade>> getTrades(T userKey) {
        return new RetrofitResult<List<Trade>>(this.client.getTrades(userKey.getUserId(), userKey.getIdentifier()), this.errorConverter);
    }

    public Result<WriteResult<Trade>> createTrade(T userKey, BUY_SELL mode, String item, int amount, String pricePerItem) {
        return new RetrofitResult<WriteResult<Trade>>(this.client.createTrade(userKey.getUserId(), mode, item, amount, pricePerItem, userKey.getIdentifier()), this.errorConverter);
    }

    public Result<WriteResult<Trade>> cancelTrade(T userKey, long tradeId) {
        return new RetrofitResult<WriteResult<Trade>>(this.client.cancelTrade(userKey.getUserId(), tradeId, userKey.getIdentifier()), this.errorConverter);
    }

    public Result<WriteResult<Trade>> takeoutTrade(T userKey, long tradeId) {
        return new RetrofitResult<WriteResult<Trade>>(this.client.takeoutTrade(userKey.getUserId(), tradeId, userKey.getIdentifier()), this.errorConverter);
    }
}

