/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.retrofitRequester;

import de._125m125.kt.ktapi.core.BUY_SELL;
import de._125m125.kt.ktapi.core.BUY_SELL_BOTH;
import de._125m125.kt.ktapi.core.entities.HistoryEntry;
import de._125m125.kt.ktapi.core.entities.Item;
import de._125m125.kt.ktapi.core.entities.Message;
import de._125m125.kt.ktapi.core.entities.OrderBookEntry;
import de._125m125.kt.ktapi.core.entities.Payout;
import de._125m125.kt.ktapi.core.entities.Permissions;
import de._125m125.kt.ktapi.core.entities.PusherResult;
import de._125m125.kt.ktapi.core.entities.Trade;
import de._125m125.kt.ktapi.core.results.WriteResult;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface KtRetrofitClient {
    @GET(value="history/{itemid}")
    public Call<List<HistoryEntry>> getHistory(@Path(value="itemid") String var1, @Query(value="limit") int var2, @Query(value="offset") int var3);

    @GET(value="history/{itemid}")
    public Call<HistoryEntry> getLatestHistory(@Path(value="itemid") String var1);

    @GET(value="orderbook/{itemid}")
    public Call<List<OrderBookEntry>> getOrderBook(@Path(value="itemid") String var1, @Query(value="limit") int var2, @Query(value="mode") BUY_SELL_BOTH var3, @Query(value="summarize") boolean var4);

    @GET(value="orderbook/{itemid}/best")
    public Call<List<OrderBookEntry>> getBestOrderBookEntries(@Path(value="itemid") String var1, @Query(value="mode") BUY_SELL_BOTH var2);

    @GET(value="permissions/{userid}")
    public Call<Permissions> getPermissions(@Path(value="userid") String var1, @Header(value="userKey") String var2);

    @GET(value="users/{userid}/items")
    public Call<List<Item>> getItems(@Path(value="userid") String var1, @Header(value="userKey") String var2);

    @GET(value="users/{userid}/items/{itemid}")
    public Call<Item> getItem(@Path(value="userid") String var1, @Path(value="itemid") String var2, @Header(value="userKey") String var3);

    @GET(value="users/{userid}/messages")
    public Call<List<Message>> getMessages(@Path(value="userid") String var1, @Header(value="userKey") String var2);

    @GET(value="users/{userid}/payouts")
    public Call<List<Payout>> getPayouts(@Path(value="userid") String var1, @Header(value="userKey") String var2);

    @GET(value="users/{userid}/payouts/{payoutid}")
    public Call<List<Payout>> getPayouts(@Path(value="userid") String var1, @Path(value="payoutid") String var2, @Header(value="userKey") String var3);

    @POST(value="users/{userid}/payouts")
    @FormUrlEncoded
    public Call<WriteResult<Payout>> createPayout(@Path(value="userid") String var1, @Field(value="type") String var2, @Field(value="item") String var3, @Field(value="amount") String var4, @Header(value="userKey") String var5);

    @POST(value="users/{userid}/payouts/{payoutid}/cancel")
    public Call<WriteResult<Payout>> cancelPayout(@Path(value="userid") String var1, @Path(value="payoutid") long var2, @Header(value="userKey") String var4);

    @POST(value="users/{userid}/payouts/{payoutid}/takout")
    public Call<WriteResult<Payout>> takeoutPayout(@Path(value="userid") String var1, @Path(value="payoutid") long var2, @Header(value="userKey") String var4);

    @POST(value="pusher/authenticate")
    @FormUrlEncoded
    public Call<PusherResult> authorizePusher(@Query(value="user") String var1, @Field(value="channel_name") String var2, @Field(value="socketId") String var3, @Header(value="userKey") String var4);

    @GET(value="users/{user}/orders")
    public Call<List<Trade>> getTrades(@Path(value="user") String var1, @Header(value="userKey") String var2);

    @POST(value="users/{user}/orders")
    @FormUrlEncoded
    public Call<WriteResult<Trade>> createTrade(@Path(value="user") String var1, @Field(value="buySell") BUY_SELL var2, @Field(value="item") String var3, @Field(value="amount") int var4, @Field(value="price") String var5, @Header(value="userKey") String var6);

    @POST(value="users/{user}/orders/{orderId}/cancel")
    public Call<WriteResult<Trade>> cancelTrade(@Path(value="user") String var1, @Path(value="orderId") long var2, @Header(value="userKey") String var4);

    @POST(value="users/{user}/orders/{orderId}/takeout")
    public Call<WriteResult<Trade>> takeoutTrade(@Path(value="user") String var1, @Path(value="orderId") long var2, @Header(value="userKey") String var4);
}

