/*
 * Decompiled with CFR 0.152.
 */
package de._125m125.kt.ktapi.websocket.okhttp;

import de._125m125.kt.ktapi.websocket.KtWebsocket;
import de._125m125.kt.ktapi.websocket.KtWebsocketManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class KtOkHttpWebsocket
implements KtWebsocket {
    private final String url;
    private final boolean externalClient;
    private final OkHttpClient client;
    private WebSocket ws;
    private KtWebsocketManager manager;

    public KtOkHttpWebsocket() {
        this(null, null);
    }

    public KtOkHttpWebsocket(String url) {
        this(url, null);
    }

    public KtOkHttpWebsocket(String url, OkHttpClient client) {
        String string = this.url = url != null ? url : "wss://kt.125m125.de/api/websocket";
        if (client != null) {
            this.client = client;
            this.externalClient = true;
        } else {
            this.client = new OkHttpClient();
            this.externalClient = false;
        }
    }

    public synchronized void close() {
        this.ws.close(1000, "client shutting down");
        if (!this.externalClient) {
            this.client.dispatcher().executorService().shutdown();
        }
    }

    public synchronized boolean connect() {
        Request request = new Request.Builder().url(this.url).build();
        KtWebsocketListener listener = new KtWebsocketListener();
        this.ws = this.client.newWebSocket(request, (WebSocketListener)listener);
        return true;
    }

    public synchronized void sendMessage(String message) {
        this.ws.send(message);
    }

    public void setManager(KtWebsocketManager manager) {
        this.manager = manager;
    }

    public class KtWebsocketListener
    extends WebSocketListener {
        public void onOpen(WebSocket webSocket, Response response) {
            new Thread(() -> ((KtWebsocketManager)KtOkHttpWebsocket.this.manager).websocketConnected()).start();
        }

        public void onMessage(WebSocket webSocket, String text) {
            KtOkHttpWebsocket.this.manager.receiveMessage(text);
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            new Thread(() -> ((KtWebsocketManager)KtOkHttpWebsocket.this.manager).websocketDisconnected()).start();
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            new Thread(() -> ((KtWebsocketManager)KtOkHttpWebsocket.this.manager).websocketDisconnected()).start();
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            t.printStackTrace();
            new Thread(() -> ((KtWebsocketManager)KtOkHttpWebsocket.this.manager).websocketDisconnected()).start();
        }
    }
}

