package de.xab.porter.transfer.jdbc.reader;

import de.xab.porter.api.dataconnection.DataConnection;

/**
 * mysql JDBC reader
 */
public class MySQLReader extends JDBCReader {
    @Override
    public String getJDBCUrl(DataConnection dataConnection) {
        String schema = dataConnection.getCatalog() == null ? dataConnection.getSchema() : dataConnection.getCatalog();
        return String.format("jdbc:%s://%s/%s?useCursorFetch=true",
                dataConnection.getType(), dataConnection.getUrl(), schema);
    }
}