/*
 * Decompiled with CFR 0.152.
 */
package de.xab.porter.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.xab.porter.api.exception.PorterException;

public final class Jsons {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private Jsons() {
    }

    public static <T> T fromJson(String content, Class<T> clazz) {
        Object t;
        try {
            t = MAPPER.readValue(content, clazz);
        }
        catch (JsonProcessingException e) {
            throw new PorterException("json deserialization failed", (Throwable)e);
        }
        return (T)t;
    }

    public static <T> T fromJson(String content, TypeReference<T> type) {
        try {
            return (T)MAPPER.readValue(content, type);
        }
        catch (JsonProcessingException e) {
            throw new PorterException("json deserialization failed", (Throwable)e);
        }
    }

    public static String toJson(Object obj) {
        String json;
        try {
            json = MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new PorterException("json serialization failed", (Throwable)e);
        }
        return json;
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

