/*
 * Decompiled with CFR 0.152.
 */
package de.xab.porter.common.util;

import com.fasterxml.jackson.core.type.TypeReference;
import de.xab.porter.common.util.Jsons;
import de.xab.porter.common.util.PorterNetworkInterceptor;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class Https {
    private static final int CONNECTION_TIMEOUT = 3;
    private static final int SOCKET_TIMEOUT = 5;
    private static final int MAX_RECURSIVE_DEPTH = 5;
    private static final MediaType JSON = MediaType.Companion.parse("application/json; charset=utf-8");
    private static final Interceptor INTERCEPTOR = new PorterNetworkInterceptor();
    private static final OkHttpClient CLIENT = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.MINUTES).readTimeout(5L, TimeUnit.MINUTES).writeTimeout(5L, TimeUnit.MINUTES).addNetworkInterceptor(INTERCEPTOR).followRedirects(false).build();

    private Https() {
    }

    public static <T> T get(String url, Map<String, String> header, Class<T> clazz) {
        return Jsons.fromJson(Https.get(url, header), clazz);
    }

    public static <T> T get(String url, Map<String, String> header, TypeReference<T> type) {
        return Jsons.fromJson(Https.get(url, header), type);
    }

    private static String get(String url, Map<String, String> header) {
        Request request = new Request.Builder().url(url).headers(Headers.Companion.of(header)).build();
        return Https.request(request);
    }

    public static <T> T post(String url, Map<String, String> header, Object body, Class<T> clazz) {
        return Jsons.fromJson(Https.post(url, header, body), clazz);
    }

    public static <T> T post(String url, Map<String, String> header, Object body, TypeReference<T> type) {
        return Jsons.fromJson(Https.post(url, header, body), type);
    }

    private static String post(String url, Map<String, String> header, Object body) {
        RequestBody requestBody = RequestBody.Companion.create(Jsons.toJson(body), JSON);
        Request request = new Request.Builder().url(url).headers(Headers.Companion.of(header)).post(requestBody).build();
        return Https.request(request);
    }

    public static <T> T put(String url, Map<String, String> header, Object body, Class<T> clazz) {
        return Jsons.fromJson(Https.put(url, header, body), clazz);
    }

    public static <T> T put(String url, Map<String, String> header, Object body, TypeReference<T> type) {
        return Jsons.fromJson(Https.put(url, header, body), type);
    }

    private static String put(String url, Map<String, String> header, Object body) {
        RequestBody requestBody = RequestBody.Companion.create(Jsons.toJson(body), JSON);
        Request request = new Request.Builder().url(url).headers(Headers.Companion.of(header)).put(requestBody).build();
        return Https.request(request);
    }

    private static String request(Request request) {
        return Https.doRequest(request, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String doRequest(Request request, int depth) {
        if (depth > 5) {
            throw new IllegalStateException("redirect exceed more than max depth");
        }
        try (Response response = CLIENT.newCall(request).execute();
             ResponseBody responseBody = response.body();){
            String result = null;
            if (response.isRedirect()) {
                String location = response.header("Location");
                String authorization = request.header("Authorization");
                if (location != null) {
                    Request.Builder builder = request.newBuilder().url(location);
                    if (authorization != null) {
                        builder.header("Authorization", authorization);
                    }
                    request = builder.build();
                    String string = Https.doRequest(request, ++depth);
                    return string;
                }
            }
            if (responseBody != null) {
                result = responseBody.string();
            }
            if (response.isSuccessful()) {
                String string = result;
                return string;
            }
            throw new IllegalStateException(String.format("request %s failed: %s %s", request.url(), response.message(), result));
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("request %s failed", request.url()), e);
        }
    }
}

