/*
 * Decompiled with CFR 0.152.
 */
package de.xab.porter.common.spi;

import de.xab.porter.api.annoation.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExtensionLoader<T> {
    private static final String FOLDER = "META-INF/porter/";
    private static final Map<Class<?>, ExtensionLoader<?>> LOADERS = new ConcurrentHashMap();
    private final Map<String, Class<T>> extensions = new ConcurrentHashMap<String, Class<T>>();
    private Class<T> service;

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> service) {
        if (service == null) {
            throw new IllegalArgumentException("service is null");
        }
        if (!service.isInterface()) {
            throw new IllegalArgumentException(String.format("service %s is not a interface", service));
        }
        ExtensionLoader<?> loader = LOADERS.get(service);
        if (loader == null) {
            LOADERS.putIfAbsent(service, new ExtensionLoader<T>());
            loader = LOADERS.get(service);
            loader.service = service;
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<T> loadExtensionClass(String type) {
        Class<Object> extensionClass = this.extensions.get(type);
        ClassLoader classLoader = this.findClassLoader(this.service);
        if (extensionClass == null) {
            Map<String, Class<T>> map = this.extensions;
            synchronized (map) {
                extensionClass = this.extensions.get(type);
                if (extensionClass == null) {
                    String extensionName = null;
                    try {
                        extensionName = this.findExtensionName(classLoader, type);
                        extensionClass = classLoader.loadClass(extensionName);
                    }
                    catch (IOException e) {
                        throw new TypeNotPresentException(type, e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException(String.format("cannot load class %s for %s: %s", extensionName, type, this.service));
                    }
                    if (!this.isServiceImplementation(extensionClass, this.service)) {
                        throw new IllegalStateException(extensionName + " not implemented " + this.service);
                    }
                    this.extensions.put(type, extensionClass);
                }
            }
        }
        if (!extensionClass.getModule().isOpen(extensionClass.getPackageName(), this.getClass().getModule())) {
            throw new RuntimeException(String.format("cannot access class %s at %s", extensionClass.getName(), this.getClass().getModule()));
        }
        return extensionClass;
    }

    public T loadExtension(String delegationType, String type) {
        T t;
        Class<T> clazz = this.loadExtensionClass(type);
        try {
            t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(String.format("cannot create extension %s of %s", type, this.service), e);
        }
        this.inject(clazz, t, delegationType);
        return t;
    }

    private void inject(Class<T> clazz, T t, String delegationType) {
        if (delegationType != null) {
            for (Method method : clazz.getMethods()) {
                Class<?> dependencyClass = null;
                if (!this.injectable(method)) continue;
                try {
                    dependencyClass = method.getParameterTypes()[0];
                    method.invoke(t, ExtensionLoader.getExtensionLoader(dependencyClass).loadExtension(null, delegationType));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(String.format("unable to inject %s to method %s", dependencyClass, method.getName()), e);
                }
            }
        }
    }

    private boolean injectable(Method method) {
        return method.isAnnotationPresent(Inject.class) && method.getName().startsWith("set") && method.getParameterTypes().length == 1 && Modifier.isPublic(method.getModifiers());
    }

    private String findExtensionName(ClassLoader classLoader, String type) throws IOException {
        String resourceFolder = FOLDER + this.service.getName();
        Enumeration<URL> urls = classLoader.getResources(resourceFolder);
        while (urls != null && urls.hasMoreElements()) {
            URL url = urls.nextElement();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Map.Entry<String, String> tuple = this.parseLine(line);
                    if (tuple == null) continue;
                    String extensionType = tuple.getKey();
                    String extensionName = tuple.getValue();
                    if (!type.equals(extensionType)) continue;
                    String string = extensionName;
                    return string;
                }
            }
        }
        throw new IOException("no appropriate type found for " + this.service);
    }

    private Map.Entry<String, String> parseLine(String line) {
        String[] split;
        int ci = line.indexOf(35);
        if (ci >= 0) {
            line = line.substring(0, ci);
        }
        if ((line = line.trim()).length() > 0 && (split = line.split("=")).length == 2) {
            String extensionType = split[0];
            String extensionName = split[1];
            return Map.entry(extensionType, extensionName);
        }
        return null;
    }

    private boolean isServiceImplementation(Class<T> extensionClass, Class<T> serviceClass) {
        boolean isImplemented = false;
        for (Class<T> currentClass = extensionClass; !isImplemented && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            isImplemented = Arrays.stream(currentClass.getInterfaces()).anyMatch(service -> service == serviceClass);
        }
        return isImplemented;
    }

    private ClassLoader findClassLoader(Class<T> clazz) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = clazz.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }
}

