package cool.scx.sql.result_handler;

import cool.scx.sql.ResultHandler;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * a
 *
 * @param <T> t
 * @author scx567888
 * @version 0.0.1
 */
public class ObjectHandler<T> implements ResultHandler<T> {

    /**
     * a
     */
    private final int columnIndex;

    /**
     * a
     */
    private final String columnName;

    /**
     * a
     */
    private final Class<T> clazz;

    /**
     * 使用名称还是索引
     */
    private final boolean useName;

    /**
     * <p>Constructor for ObjectHandler.</p>
     *
     * @param columnIndex a int
     * @param clazz       a {@link java.lang.Class} object
     */
    public ObjectHandler(int columnIndex, Class<T> clazz) {
        this.columnIndex = columnIndex;
        this.columnName = null;
        this.clazz = clazz;
        this.useName = false;
    }

    /**
     * <p>Constructor for ObjectHandler.</p>
     *
     * @param columnName a {@link java.lang.String} object
     * @param clazz      a {@link java.lang.Class} object
     */
    public ObjectHandler(String columnName, Class<T> clazz) {
        this.columnIndex = 0;
        this.columnName = columnName;
        this.clazz = clazz;
        this.useName = true;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public T handle(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return useName ? rs.getObject(this.columnName, clazz) : rs.getObject(this.columnIndex, clazz);
        }
        return null;
    }

}
